/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshException;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritProjectListUpdater
extends Thread
implements ConnectionListener {
    public static final String GERRIT_LS_PROJECTS = "gerrit ls-projects";
    private static final int UPDATE_DELAY = 3600000;
    private boolean connected = false;
    private boolean shutdown = false;
    private static final Logger logger = LoggerFactory.getLogger(GerritProjectListUpdater.class);
    private List<String> gerritProjects;

    public GerritProjectListUpdater() {
        this.setName(this.getClass().getName() + " Thread");
        this.setDaemon(true);
        this.connected = PluginImpl.getInstance().addListener(this);
    }

    public synchronized void connectionEstablished() {
        this.setConnected(true);
        this.notify();
    }

    public synchronized void connectionDown() {
        this.setConnected(false);
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                if (PluginImpl.getInstance() != null && PluginImpl.getInstance().getConfig() != null && this.isConnected()) {
                    IGerritHudsonTriggerConfig activeConfig = PluginImpl.getInstance().getConfig();
                    SshConnection sshConnection = SshConnectionFactory.getConnection((String)activeConfig.getGerritHostName(), (int)activeConfig.getGerritSshPort(), (Authentication)activeConfig.getGerritAuthentication());
                    this.setGerritProjects(GerritProjectListUpdater.readProjects(sshConnection.executeCommandReader(GERRIT_LS_PROJECTS)));
                    sshConnection.disconnect();
                }
            }
            catch (SshException ex) {
                logger.warn("Could not connect to Gerrit server when updating Gerrit project list: ", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error("Could not read stream with Gerrit projects: ", (Throwable)ex);
            }
            try {
                GerritProjectListUpdater ex = this;
                synchronized (ex) {
                    this.wait(3600000L);
                }
            }
            catch (InterruptedException ex) {
                logger.warn("InterruptedException: ", (Throwable)ex);
                break;
            }
        }
        PluginImpl.getInstance().removeListener(this);
    }

    public static List<String> readProjects(Reader commandReader) throws IOException {
        ArrayList<String> projects = new ArrayList<String>();
        BufferedReader br = new BufferedReader(commandReader);
        String line = br.readLine();
        while (line != null) {
            projects.add(line);
            line = br.readLine();
        }
        return projects;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    public synchronized void setGerritProjects(List<String> projects) {
        this.gerritProjects = projects;
    }

    public synchronized List<String> getGerritProjects() {
        if (this.gerritProjects == null) {
            this.gerritProjects = new ArrayList<String>();
        }
        return this.gerritProjects;
    }
}

