/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.jenkins.plugins.tpt.publisher.TPTGlobalConfiguration;
import com.piketec.jenkins.plugins.tpt.publisher.TPTReportPage;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TrendGraph
implements RunAction2,
StaplerProxy {
    private static final String INDENT = "\t";
    private static final String LF = "\n";
    private AbstractProject<?, ?> project;
    private AbstractBuild<?, ?> actualBuild;
    private transient Run<?, ?> run;
    private ArrayList<Integer> failedBuilds = new ArrayList();
    private int passed;
    private int inconclusive;
    private int error;
    private int failed;
    private ArrayList<ResultData> historyData = new ArrayList();

    public TrendGraph(AbstractProject<?, ?> project) {
        this.project = project;
        this.initBuildAndTestCaseResultCounts();
        this.setHistoryIterativ();
    }

    public boolean isTrustSlavesAndUsers() {
        return TPTGlobalConfiguration.DescriptorImpl.trustSlavesAndUsers;
    }

    private void initBuildAndTestCaseResultCounts() {
        this.actualBuild = (AbstractBuild)this.project.getLastSuccessfulBuild();
        if (this.actualBuild == null) {
            return;
        }
        Action tptAction = this.actualBuild.getAction(TPTReportPage.class);
        if (tptAction == null) {
            return;
        }
        this.passed = ((TPTReportPage)tptAction).getPassedCount();
        this.inconclusive = ((TPTReportPage)tptAction).getInconclusiveCount();
        this.error = ((TPTReportPage)tptAction).getErrorCount();
        this.failed = ((TPTReportPage)tptAction).getFailedCount();
    }

    private void refreshTrendGraph() {
        this.historyData.clear();
        this.setHistoryIterativ();
        this.initBuildAndTestCaseResultCounts();
    }

    private void setHistoryIterativ() {
        if (this.actualBuild == null) {
            return;
        }
        Result result = this.actualBuild.getResult();
        if (result == null) {
            return;
        }
        List builds = this.actualBuild.getPreviousBuildsOverThreshold(20, Result.UNSTABLE);
        if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
            builds.add(0, this.actualBuild);
        }
        for (Run run : builds) {
            ResultData toAdd = new ResultData();
            TPTReportPage tptAction = (TPTReportPage)run.getAction(TPTReportPage.class);
            if (tptAction == null) continue;
            toAdd.buildNummer = run.getNumber();
            toAdd.error = tptAction.getErrorCount();
            toAdd.passed = tptAction.getPassedCount();
            toAdd.inconclusive = tptAction.getInconclusiveCount();
            toAdd.failed = tptAction.getFailedCount();
            toAdd.total = toAdd.error + toAdd.failed + toAdd.passed + toAdd.inconclusive;
            this.historyData.add(toAdd);
        }
    }

    public String getIconFileName() {
        return "/plugin/piketec-tpt/tpt.ico";
    }

    public String getDisplayName() {
        return "TPT Trend Results";
    }

    public String getUrlName() {
        return "TPTtrendResults";
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public void setProject(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void setRun(Run<?, ?> run) {
        this.run = run;
    }

    public ArrayList<Integer> getFailedBuilds() {
        return this.failedBuilds;
    }

    public void setFailedBuilds(ArrayList<Integer> failedBuilds) {
        this.failedBuilds = failedBuilds;
    }

    public int getPassed() {
        return this.passed;
    }

    public void setPassed(int passed) {
        this.passed = passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int getInconclusive() {
        return this.inconclusive;
    }

    public void setInconclusive(int inconclusive) {
        this.inconclusive = inconclusive;
    }

    public ArrayList<ResultData> getHistoryData() {
        return this.historyData;
    }

    public Object getTarget() {
        return this;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.actualBuild = (AbstractBuild)this.project.getLastSuccessfulBuild();
        this.refreshTrendGraph();
        if (this.actualBuild == null) {
            return;
        }
        TPTGlobalConfiguration.setSecurity();
        this.generateJson();
        File buildDir = this.actualBuild.getRootDir();
        DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(new File(buildDir.getAbsolutePath() + File.separator + "TrendGraph")), "TPT Report", "/plugin/piketec-tpt/tpt.ico", false);
        if (req.getRestOfPath().equals("")) {
            throw HttpResponses.forwardToView((Object)this, (String)"index.jelly");
        }
        dbs.generateResponse(req, rsp, (Object)this);
    }

    private void generateJson() throws IOException, InterruptedException {
        File oldIndexHTML = new File(Utils.getTptPluginRootDir(), "TrendGraph" + File.separator + "index.html");
        File utilsJs = new File(Utils.getTptPluginRootDir(), "TrendGraph" + File.separator + "utils.js");
        File buildDir = this.actualBuild.getRootDir();
        File trendGraph = new File(buildDir.getAbsolutePath() + File.separator + "TrendGraph");
        if (!trendGraph.isDirectory() && !trendGraph.mkdirs()) {
            throw new IOException("Could not create directory \"" + trendGraph.getAbsolutePath() + "\"");
        }
        if (utilsJs.exists()) {
            FileUtils.copyFileToDirectory((File)utilsJs, (File)trendGraph);
            FileUtils.copyFileToDirectory((File)oldIndexHTML, (File)trendGraph);
        }
        String jsonScript = TrendGraph.getResultArray(this.historyData);
        String newIndexHTMLWithJson = FileUtils.readFileToString((File)oldIndexHTML);
        newIndexHTMLWithJson = newIndexHTMLWithJson.replace("toReplace", jsonScript);
        File newIndexHTML = new File(buildDir.getAbsolutePath() + File.separator + "TrendGraph" + File.separator + "index.html");
        FileUtils.writeStringToFile((File)newIndexHTML, (String)newIndexHTMLWithJson);
    }

    private static String getResultArray(ArrayList<ResultData> data) {
        StringBuffer buf = new StringBuffer();
        int indent = 1;
        buf.append(StringUtils.repeat((String)INDENT, (int)(indent + 1)) + " { \"data\" : [" + LF);
        for (int i = 0; i < data.size(); ++i) {
            ResultData currentData = data.get(i);
            if (i == data.size() - 1) {
                buf.append(TrendGraph.getResultStruct(currentData.total, currentData.failed, currentData.inconclusive, currentData.error, currentData.passed, currentData.buildNummer, indent + 1, false));
                continue;
            }
            buf.append(TrendGraph.getResultStruct(currentData.total, currentData.failed, currentData.inconclusive, currentData.error, currentData.passed, currentData.buildNummer, indent + 1, true));
        }
        buf.append(StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "]" + LF);
        buf.append("}");
        return buf.toString();
    }

    private static String getResultStruct(int total, int failed, int inconclusive, int error, int passed, int buildNummer, int indent, boolean withComma) {
        StringBuffer buf = new StringBuffer();
        buf.append(StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "[" + LF);
        buf.append(TrendGraph.getJSONIntEntry("buildNummer", buildNummer, indent + 1, true));
        buf.append(TrendGraph.getJSONIntEntry("total", total, indent + 1, true));
        buf.append(TrendGraph.getJSONIntEntry("failed", failed, indent + 1, true));
        buf.append(TrendGraph.getJSONIntEntry("inconclusive", inconclusive, indent + 1, true));
        buf.append(TrendGraph.getJSONIntEntry("error", error, indent + 1, true));
        buf.append(TrendGraph.getJSONIntEntry("passed", passed, indent + 1));
        if (withComma) {
            buf.append(StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "]," + LF);
        } else {
            buf.append(StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "]" + LF);
        }
        return buf.toString();
    }

    private static String getJSONIntEntry(String name, int value, int indent, boolean withComma) {
        if (withComma) {
            return StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "{\"" + name + "\" : " + value + "}," + LF;
        }
        return StringUtils.repeat((String)INDENT, (int)(indent + 1)) + "{\"" + name + "\" : " + value + "}" + LF;
    }

    private static String getJSONIntEntry(String name, int value, int indent) {
        return TrendGraph.getJSONIntEntry(name, value, indent, false);
    }

    public static class ResultData {
        public int total;
        public int error;
        public int failed;
        public int passed;
        public int inconclusive;
        public int buildNummer;
    }
}

