/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import com.piketec.jenkins.plugins.tpt.publisher.TPTFile;
import com.piketec.jenkins.plugins.tpt.publisher.TPTTestCase;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TPTReportSAXHandler
extends DefaultHandler {
    private static final String TESTCASEINFORMATION = "TestcaseInformation";
    private static final String TESTCASE = "Testcase";
    private ArrayList<TPTTestCase> failedTests;
    private TPTFile tptFile;
    private String reportDir;
    private Map<String, String> nameAndId;
    private String executionConfiguration;
    private Map<String, Integer> resultCount;
    private boolean isFileCorrupt;

    public TPTReportSAXHandler(TPTFile tptFile, ArrayList<TPTTestCase> failedTests, String reportDirOnRemote, String executionConfiguration, boolean isFileCorrupt) {
        this.reportDir = reportDirOnRemote;
        this.tptFile = tptFile;
        this.failedTests = failedTests;
        this.executionConfiguration = executionConfiguration;
        this.isFileCorrupt = isFileCorrupt;
        this.nameAndId = new HashMap<String, String>();
        this.resultCount = new HashMap<String, Integer>();
        this.resultCount.put("PASSED", 0);
        this.resultCount.put("INCONCLUSIVE", 0);
        this.resultCount.put("FAILED", 0);
        this.resultCount.put("ERROR", 0);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TESTCASE.equalsIgnoreCase(qName)) {
            String id = attributes.getValue("Id");
            String name = attributes.getValue("Name");
            this.nameAndId.put(id, name);
            if (this.isFileCorrupt) {
                int currentResultValue = this.resultCount.get("ERROR") + 1;
                this.resultCount.put("ERROR", currentResultValue);
                TPTTestCase t = new TPTTestCase();
                t.setId(id);
                t.setExecutionDate(new Date().toString());
                t.setResult("ERROR");
                t.setFileName(this.tptFile.getFileName());
                t.setPlatform("Corrupted Platform");
                t.setReportFile("Corrupted File");
                t.setExecutionConfiguration(this.executionConfiguration);
                t.setTestCaseName(name);
                this.failedTests.add(t);
                this.setResultsToTPTFile();
            }
        }
        if (TESTCASEINFORMATION.equalsIgnoreCase(qName)) {
            String result = attributes.getValue("Result").toUpperCase();
            int currentResultValue = this.resultCount.get(result) + 1;
            this.resultCount.put(result, currentResultValue);
            String id = attributes.getValue(TESTCASE);
            String executionDate = attributes.getValue("ExecutionDate");
            String reportFile = attributes.getValue("ReportFile");
            String fileName = this.tptFile.getFileName();
            if (!result.equals("PASSED")) {
                TPTTestCase t = new TPTTestCase();
                t.setId(id);
                t.setExecutionDate(executionDate);
                t.setResult(result);
                t.setFileName(fileName);
                reportFile = this.getLinkToFailedReport(reportFile, this.reportDir);
                t.setPlatform(this.getPlatformName(reportFile));
                t.setReportFile(reportFile);
                t.setExecutionConfiguration(this.executionConfiguration);
                t.setTestCaseName(this.nameAndId.get(id));
                this.failedTests.add(t);
            }
            this.setResultsToTPTFile();
        }
    }

    private void setResultsToTPTFile() {
        int error = this.resultCount.get("ERROR");
        int failed = this.resultCount.get("FAILED");
        int inconclusive = this.resultCount.get("INCONCLUSIVE");
        int passed = this.resultCount.get("PASSED");
        int total = error + failed + inconclusive + passed;
        this.tptFile.setExecutionError(error);
        this.tptFile.setFailed(failed);
        this.tptFile.setInconclusive(inconclusive);
        this.tptFile.setPassed(passed);
        this.tptFile.setTotal(total);
    }

    private String getPlatformName(String reportFile) {
        int index = reportFile.indexOf("\\");
        if (index < 0) {
            return reportFile;
        }
        return reportFile.substring(0, index);
    }

    private String getLinkToFailedReport(String reportFile, String reportDir) {
        if (reportFile.equals("")) {
            return "";
        }
        Path path = Paths.get(reportDir, new String[0]);
        return path.relativize(Paths.get(reportFile, new String[0])).toFile().getPath();
    }
}

