/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.Publish;
import com.piketec.jenkins.plugins.tpt.TPTBuildStepEntries;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.jenkins.plugins.tpt.publisher.TPTFile;
import com.piketec.jenkins.plugins.tpt.publisher.TPTGlobalConfiguration;
import com.piketec.jenkins.plugins.tpt.publisher.TPTReportPage;
import com.piketec.jenkins.plugins.tpt.publisher.TPTReportSAXHandler;
import com.piketec.jenkins.plugins.tpt.publisher.TPTTestCase;
import com.piketec.jenkins.plugins.tpt.publisher.TrendGraph;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TPTReportPublisher
extends Notifier {
    @DataBoundConstructor
    public TPTReportPublisher() {
        TPTGlobalConfiguration.setSecurity();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        TPTReportPage lastTptFilesAction;
        TptLogger logger = new TptLogger(listener.getLogger());
        logger.info("Starting Post Build Action \"TPT Report\"");
        List<JenkinsConfiguration> jenkinsConfigurationsToPublishForThisWorkspace = TPTBuildStepEntries.getEntries(build);
        if (jenkinsConfigurationsToPublishForThisWorkspace == null) {
            logger.info("Nothing to publish");
            return false;
        }
        ArrayList<FilePath> uniqueTestDataDir = new ArrayList<FilePath>();
        ArrayList<FilePath> uniqueReportDataDir = new ArrayList<FilePath>();
        ArrayList<TPTFile> tptFiles = new ArrayList<TPTFile>();
        ArrayList<TPTTestCase> failedTests = new ArrayList<TPTTestCase>();
        FilePath workspace = build.getWorkspace();
        File piketectptDir = new File(build.getRootDir().getAbsolutePath() + File.separator + "Piketec-TPT");
        if (!piketectptDir.exists() && !piketectptDir.mkdirs()) {
            throw new IOException("Could not create directory \"" + piketectptDir.getAbsolutePath() + "\"");
        }
        for (JenkinsConfiguration cfg : jenkinsConfigurationsToPublishForThisWorkspace) {
            FilePath reportXML;
            String tptFileName = FilenameUtils.getBaseName((String)cfg.getTptFile());
            File dir = new File(piketectptDir.getAbsolutePath() + File.separator + tptFileName);
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new IOException("Could not create directory \"" + dir.getAbsolutePath() + "\"");
            }
            File dirExConfig = new File(piketectptDir.getAbsolutePath() + File.separator + tptFileName + File.separator + cfg.getConfiguration());
            if (!dirExConfig.mkdirs()) {
                throw new IOException("Could not create directory \"" + dirExConfig.getAbsolutePath() + "\"");
            }
            FilePath reportDir = new FilePath(workspace, Utils.getGeneratedReportDir(cfg));
            FilePath testDataDir = new FilePath(workspace, Utils.getGeneratedTestDataDir(cfg));
            if (reportDir.exists()) {
                reportDir.copyRecursiveTo(new FilePath(dirExConfig));
            }
            if (!(reportXML = new FilePath(testDataDir, "test_summary.xml")).exists()) {
                logger.error("There is no test_summary.xml for the file \"" + tptFileName + "\".It won't be published ");
                continue;
            }
            TPTFile newTPTFile = new TPTFile(tptFileName, cfg.getConfiguration());
            boolean isFileCorrupt = this.checkForTestCaseInformation(testDataDir);
            this.parse(reportXML, newTPTFile, failedTests, reportDir.getRemote(), cfg.getConfiguration(), logger, isFileCorrupt);
            tptFiles.add(newTPTFile);
            if (uniqueReportDataDir.contains(reportDir) || uniqueTestDataDir.contains(testDataDir)) {
                throw new IOException("The directory \"" + cfg.getReportDir() + "\" or the directoy \"" + cfg.getTestdataDir() + "\" is already used, please choose another one");
            }
            uniqueReportDataDir.add(reportDir);
            uniqueTestDataDir.add(testDataDir);
        }
        AbstractBuild lastSuccBuild = (AbstractBuild)build.getPreviousNotFailedBuild();
        TPTReportPage tPTReportPage = lastTptFilesAction = lastSuccBuild == null ? null : (TPTReportPage)lastSuccBuild.getAction(TPTReportPage.class);
        if (lastTptFilesAction != null) {
            HashMap<FailedTestKey, TPTTestCase> prevFailed = new HashMap<FailedTestKey, TPTTestCase>();
            for (TPTTestCase tptTestCase : lastTptFilesAction.getFailedTests()) {
                prevFailed.put(new FailedTestKey(tptTestCase.getId(), tptTestCase.getFileName(), tptTestCase.getExecutionConfiguration(), tptTestCase.getPlatform()), tptTestCase);
            }
            for (TPTTestCase t : failedTests) {
                String platform;
                String exeConfig;
                String fileName;
                String id = t.getId();
                FailedTestKey ftk = new FailedTestKey(id, fileName = t.getFileName(), exeConfig = t.getExecutionConfiguration(), platform = t.getPlatform());
                if (!prevFailed.containsKey(ftk)) continue;
                t.setFailedSince(((TPTTestCase)prevFailed.get(ftk)).getFailedSince() + 1);
            }
        }
        TPTReportPage filesAction = new TPTReportPage(build, failedTests, tptFiles);
        filesAction.createGraph();
        build.addAction((Action)filesAction);
        listener.getLogger().println("Finished Post Build Action");
        if (!failedTests.isEmpty()) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private boolean checkForTestCaseInformation(FilePath testDataDir) throws IOException, InterruptedException {
        HashSet<FilePath> files = new HashSet<FilePath>();
        Publish.find(testDataDir, "testcase_information.xml", files);
        boolean containsTestcaseInformation = false;
        FilePath summaryXMl = new FilePath(testDataDir, "test_summary.xml");
        if (summaryXMl.exists()) {
            InputStream inputStream = summaryXMl.read();
            String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            containsTestcaseInformation = result.contains("TestcaseInformation");
        }
        return files.size() == 0 && !containsTestcaseInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(FilePath xmlFile, TPTFile tptFile, ArrayList<TPTTestCase> failedTests, String reportDirOnRemote, String executionConfiguration, TptLogger logger, boolean isFileCorrupt) throws InterruptedException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            TPTReportSAXHandler handler = new TPTReportSAXHandler(tptFile, failedTests, reportDirOnRemote, executionConfiguration, isFileCorrupt);
            InputStream inputStream = xmlFile.read();
            try {
                saxParser.parse(inputStream, (DefaultHandler)handler);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage());
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TrendGraph(project);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private static class FailedTestKey {
        private final String id;
        private final String fileName;
        private final String exeConfig;
        private final String platform;

        public FailedTestKey(String id, String fileName, String exeConfig, String platform) {
            this.id = id;
            this.fileName = fileName;
            this.exeConfig = exeConfig;
            this.platform = platform;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exeConfig == null ? 0 : this.exeConfig.hashCode());
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FailedTestKey other = (FailedTestKey)obj;
            if (this.exeConfig == null ? other.exeConfig != null : !this.exeConfig.equals(other.exeConfig)) {
                return false;
            }
            if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.platform == null ? other.platform != null : !this.platform.equals(other.platform));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "TPT Report";
        }
    }
}

