/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import com.piketec.jenkins.plugins.tpt.publisher.InvisibleActionHostingHtml;
import com.piketec.jenkins.plugins.tpt.publisher.InvisibleActionHostingImages;
import com.piketec.jenkins.plugins.tpt.publisher.OpenReportForFailedTestAction;
import com.piketec.jenkins.plugins.tpt.publisher.PieChart;
import com.piketec.jenkins.plugins.tpt.publisher.SecurityErrorAction;
import com.piketec.jenkins.plugins.tpt.publisher.TPTFile;
import com.piketec.jenkins.plugins.tpt.publisher.TPTGlobalConfiguration;
import com.piketec.jenkins.plugins.tpt.publisher.TPTTestCase;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TPTReportPage
implements RunAction2,
StaplerProxy {
    private AbstractBuild<?, ?> build;
    private transient Run run;
    private List<TPTTestCase> failedTests;
    private List<TPTFile> tptFiles;
    private int passedCount = 0;
    private int inconclusiveCount = 0;
    private int errorCount = 0;
    private int failedCount = 0;
    private static final Color COLOR_GREEN = Color.GREEN.darker();
    private static final Color COLOR_YELLOW = new Color(14535689);
    private static final Color COLOR_RED = new Color(240, 0, 0);
    private static final Color COLOR_BROWN = new Color(177, 7, 7);

    public TPTReportPage(AbstractBuild<?, ?> build, ArrayList<TPTTestCase> failedTests, ArrayList<TPTFile> tptFiles) {
        for (TPTFile f : tptFiles) {
            this.passedCount += f.getPassed();
            this.inconclusiveCount += f.getInconclusive();
            this.errorCount += f.getExecutionError();
            this.failedCount += f.getFailed();
        }
        this.build = build;
        this.setFailedTests(failedTests);
        this.setTptFiles(tptFiles);
    }

    public String getIconFileName() {
        return "/plugin/piketec-tpt/tpt.ico";
    }

    public String getDisplayName() {
        return "TPT Report";
    }

    public String getUrlName() {
        return "TPT_Report";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public void setBuild(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run getRun() {
        return this.run;
    }

    public Object getTarget() {
        return this;
    }

    public List<TPTFile> getTptFiles() {
        return this.tptFiles;
    }

    public void setTptFiles(List<TPTFile> tptFiles) {
        this.tptFiles = tptFiles;
    }

    public List<TPTTestCase> getFailedTests() {
        return this.failedTests;
    }

    public void setFailedTests(ArrayList<TPTTestCase> failedTests) {
        this.failedTests = failedTests;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(int passedCount) {
        this.passedCount = passedCount;
    }

    public int getInconclusiveCount() {
        return this.inconclusiveCount;
    }

    public void setInconclusiveCount(int inconclusiveCount) {
        this.inconclusiveCount = inconclusiveCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public boolean isTrustSlavesAndUsers() {
        return TPTGlobalConfiguration.DescriptorImpl.trustSlavesAndUsers;
    }

    public int getNumberFromHistory(int failedSince) {
        List previousBuilds = this.build.getPreviousBuildsOverThreshold(failedSince - 1, Result.UNSTABLE);
        if (previousBuilds.isEmpty()) {
            return this.build.getNumber();
        }
        return ((Run)previousBuilds.get(previousBuilds.size() - 1)).getNumber();
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        if (name.equals("SecurityError")) {
            return new SecurityErrorAction();
        }
        if (name.equals("Images")) {
            return new InvisibleActionHostingImages(this.build);
        }
        for (TPTTestCase tPTTestCase : this.failedTests) {
            if (!name.equals(tPTTestCase.getFileName() + tPTTestCase.getExecutionConfiguration() + tPTTestCase.getId() + tPTTestCase.getPlatform() + tPTTestCase.getExecutionDate())) continue;
            return new OpenReportForFailedTestAction(this.build, tPTTestCase.getFileName(), tPTTestCase.getReportFile(), tPTTestCase.getId(), tPTTestCase.getExecutionConfiguration(), tPTTestCase.getPlatform(), tPTTestCase.getExecutionDate());
        }
        for (TPTFile tPTFile : this.tptFiles) {
            if (!name.equals(tPTFile.getFileName() + tPTFile.getConfiguration())) continue;
            return new InvisibleActionHostingHtml(this.build, tPTFile.getFileName(), tPTFile.getConfiguration());
        }
        return null;
    }

    void createGraph() throws IOException {
        ArrayList<PieChart.Segment> list = new ArrayList<PieChart.Segment>();
        PieChart.Segment passed = new PieChart.Segment("Passed", this.passedCount, COLOR_GREEN);
        PieChart.Segment inconlusive = new PieChart.Segment("Inconclusive", this.inconclusiveCount, COLOR_YELLOW);
        PieChart.Segment error = new PieChart.Segment("Error", this.errorCount, COLOR_BROWN);
        PieChart.Segment failed = new PieChart.Segment("Failed", this.failedCount, COLOR_RED);
        list.add(passed);
        list.add(inconlusive);
        list.add(error);
        list.add(failed);
        PieChart pieChart = new PieChart(list, 0, true);
        File output = new File(this.build.getRootDir().getAbsolutePath() + File.separator + "Piketec-TPT" + File.separator + "Images" + File.separator + "pieChart.png");
        BufferedImage image = pieChart.render(150);
        if (!output.exists() && !output.mkdirs()) {
            throw new IOException("Could not create directory " + output.getAbsolutePath());
        }
        if (!ImageIO.write((RenderedImage)image, "png", output)) {
            throw new IOException("Could not create pie chart");
        }
    }
}

