/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class TPTGlobalConfiguration
implements Describable<TPTGlobalConfiguration> {
    public static void setSecurity() {
        if (DescriptorImpl.trustSlavesAndUsers) {
            System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", "");
        } else if (DescriptorImpl.staticOldSettings != null) {
            System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", DescriptorImpl.staticOldSettings);
        }
    }

    public static boolean isTrustSlavesAndUsers() {
        return DescriptorImpl.trustSlavesAndUsers;
    }

    public Descriptor<TPTGlobalConfiguration> getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        Descriptor descriptor = instance.getDescriptor(this.getClass());
        return descriptor;
    }

    @DataBoundConstructor
    public TPTGlobalConfiguration() {
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TPTGlobalConfiguration> {
        static boolean trustSlavesAndUsers;
        static String staticOldSettings;
        private String oldSettings;
        private boolean toSave;

        public DescriptorImpl() {
            this.load();
            DescriptorImpl.setTrustSlavesAndUsers(this.toSave);
            DescriptorImpl.setStaticOldSettings(this.oldSettings);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            json = json.getJSONObject("securityPermission");
            DescriptorImpl.setTrustSlavesAndUsers(json.getBoolean("trustSlavesAndUsers"));
            this.toSave = trustSlavesAndUsers;
            if (!this.toSave) {
                this.setStaticOldSettings();
            }
            this.oldSettings = staticOldSettings;
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "";
        }

        public static void setTrustSlavesAndUsers(boolean enableTrustSlavesAndUsers) {
            trustSlavesAndUsers = enableTrustSlavesAndUsers;
        }

        public static boolean isTrustSlavesAndUsers() {
            return trustSlavesAndUsers;
        }

        public static boolean getTrustSlavesAndUsers() {
            return trustSlavesAndUsers;
        }

        static void setStaticOldSettings(String oldSettings) {
            staticOldSettings = oldSettings;
        }

        private void setStaticOldSettings() {
            String settings = System.getProperty("hudson.model.DirectoryBrowserSupport.CSP");
            String string = settings = settings == null ? "sandbox; default-src 'none'; img-src 'self'; style-src 'self';" : settings;
            if (staticOldSettings == null) {
                staticOldSettings = settings;
            }
            System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", staticOldSettings);
        }
    }
}

