/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ArrayUtils;

class PieChart {
    private static final Color BRIGHT_GRAY = new Color(240, 242, 240);
    private static final Font NORMALFONT = new Font("Dialog", 0, 12);
    final int centerX = 296;
    final int centerY = 287;
    final int radius = 263;
    final int totalHeight = 616;
    final int totalWidth = 1232;
    double zoom = 1.0;
    private final List<Segment> segments;
    private final boolean showTotalInLegend;
    private final double total;
    private final boolean withSubSegments;
    private final String subTotalTextOrNull;
    private final double subTotal;
    private final DecimalFormat legendPortionFormat;
    private final int[] legendSegmentOrder;
    private final String totalText = "in total";
    private ImageIcon pieShadow;
    private ImageIcon keyShadow;

    private static void checkLegendSegmentOrder(List<Segment> segments, int[] legendSegmentOrder) {
        if (legendSegmentOrder == null) {
            return;
        }
        assert (legendSegmentOrder.length == segments.size());
        for (int i = 0; i < legendSegmentOrder.length; ++i) {
            assert (ArrayUtils.contains((int[])legendSegmentOrder, (int)i));
        }
    }

    public PieChart(List<Segment> segments, int fractionalDigits, boolean showTotalInLegend) throws MalformedURLException, IOException {
        this(segments, null, fractionalDigits, showTotalInLegend, false, null);
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance == null) {
            throw new IOException("No Jenkins instance found.");
        }
        this.pieShadow = new ImageIcon(new File(jenkinsInstance.getRootDir(), File.separator + "plugins" + File.separator + "piketec-tpt" + File.separator + "PieChart" + File.separator + "Shadow.png").toURI().toURL());
        this.keyShadow = new ImageIcon(new File(jenkinsInstance.getRootDir(), File.separator + "plugins" + File.separator + "piketec-tpt" + File.separator + "PieChart" + File.separator + "Shadow2.png").toURI().toURL());
    }

    public PieChart(List<Segment> segments, @Nullable int[] legendSegmentOrder, int fractionalDigits, boolean showTotalInLegend, boolean withSubSegments, String subTotalTextOrNull) {
        PieChart.checkLegendSegmentOrder(segments, legendSegmentOrder);
        this.segments = segments;
        this.showTotalInLegend = showTotalInLegend;
        this.legendSegmentOrder = legendSegmentOrder != null ? (int[])legendSegmentOrder.clone() : null;
        this.withSubSegments = withSubSegments;
        this.subTotalTextOrNull = subTotalTextOrNull;
        double sum = 0.0;
        double subSum = 0.0;
        if (showTotalInLegend) {
            for (Segment seg : segments) {
                sum += seg.getPortion();
                subSum += seg.getSubPortion();
            }
        }
        this.total = sum;
        this.subTotal = subSum;
        StringBuilder pattern = new StringBuilder("#,##0");
        if (fractionalDigits > 0) {
            pattern.append('.');
            for (int i = 0; i < fractionalDigits; ++i) {
                pattern.append('0');
            }
        }
        this.legendPortionFormat = new DecimalFormat(pattern.toString());
    }

    public BufferedImage render(int height) {
        BufferedImage image = new BufferedImage(1232, 616, 1);
        Graphics2D g2 = image.createGraphics();
        g2.scale(this.zoom, this.zoom);
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle(1232, 616));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setStroke(new BasicStroke(4.0f, 1, 1));
        g2.drawImage(this.pieShadow.getImage(), 0, 0, this.pieShadow.getImageObserver());
        double start = 0.0;
        ArrayList<Arc2D> pies = new ArrayList<Arc2D>();
        if (this.total == 0.0) {
            g2.setColor(BRIGHT_GRAY);
            g2.fillOval(33, 24, 526, 526);
            g2.setColor(Color.WHITE);
            g2.drawOval(33, 24, 526, 526);
        } else {
            for (Segment s : this.segments) {
                double portionDegrees = s.getPortion() / this.total;
                Arc2D pie = this.paintPieSegment(g2, start, portionDegrees, s.getColor());
                if (this.withSubSegments) {
                    double smallRadius = 263.0 * s.getSubSegmentRatio();
                    this.paintPieSegment(g2, start, portionDegrees, smallRadius, s.getColor().darker());
                }
                start += portionDegrees;
                String p = String.format(Locale.ENGLISH, "%.1f", Math.rint(portionDegrees * 1000.0) / 10.0);
                p = PieChart.removeSuffix(p, ".0");
                s.setPercent(p + "%");
                pies.add(pie);
            }
            g2.setColor(Color.WHITE);
            for (Arc2D pie : pies) {
                g2.draw(pie);
            }
        }
        this.renderLegend(g2);
        g2.setColor(Color.WHITE);
        float fontSize = 32.0f;
        g2.setFont(NORMALFONT.deriveFont(fontSize).deriveFont(1));
        start = 0.0;
        for (Segment s : this.segments) {
            if (s.getPortion() < 1.0E-6) continue;
            double portionDegrees = s.getPortion() / this.total;
            double angle = start + portionDegrees / 2.0;
            double xOffsetForCenteredTxt = 8 * s.getPercent().length();
            int x = (int)(296.0 + 157.79999999999998 * Math.sin(Math.PI * 2 * angle) - xOffsetForCenteredTxt);
            int y = (int)(287.0 - 157.79999999999998 * Math.cos(Math.PI * 2 * angle) + (double)(fontSize / 2.0f));
            g2.drawString(s.getPercent(), x, y);
            start += portionDegrees;
        }
        return image;
    }

    private void renderLegend(Graphics2D g2) {
        g2.setFont(NORMALFONT.deriveFont(32.0f).deriveFont(1));
        Font font = g2.getFont();
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        HashMap<Segment, Double> numberWidths = new HashMap<Segment, Double>();
        double maxNumberWidth = 0.0;
        for (Segment seg : this.segments) {
            double numberWidth = font.getStringBounds(this.legendPortionFormat.format(seg.getPortion()), fontRenderContext).getWidth();
            numberWidths.put(seg, numberWidth);
            maxNumberWidth = Math.max(maxNumberWidth, numberWidth);
        }
        if (this.showTotalInLegend) {
            double numberWidth = font.getStringBounds(this.legendPortionFormat.format(this.total), fontRenderContext).getWidth();
            numberWidths.put(null, numberWidth);
            maxNumberWidth = Math.max(maxNumberWidth, numberWidth);
        }
        int verticalOffset = 0;
        for (int row = 0; row < this.segments.size(); ++row) {
            Segment seg = this.getLegendSegment(row);
            double indentation = maxNumberWidth - (Double)numberWidths.get(seg);
            String segmentPortionNumber = this.legendPortionFormat.format(seg.getPortion());
            String segmentText = seg.getText();
            Color segmentColor = seg.getColor();
            String subSegmentText = seg.getSubSegmentText();
            String subNumberText = this.legendPortionFormat.format(seg.subPortion);
            this.drawLegendLine(g2, verticalOffset, indentation, segmentColor, segmentText, segmentPortionNumber, seg.getPortion() != 1.0, seg.getSubPortion() > 0.0, subSegmentText, subNumberText, seg.getSubPortion() != 1.0);
            verticalOffset += 85;
        }
        if (this.showTotalInLegend) {
            double indentation = maxNumberWidth - (Double)numberWidths.get(null);
            String subNumberText = this.legendPortionFormat.format(this.subTotal);
            this.drawLegendLine(g2, verticalOffset, indentation, null, "in total", this.legendPortionFormat.format(this.total), this.total != 1.0, this.subTotalTextOrNull != null, this.subTotalTextOrNull, subNumberText, this.subTotal != 1.0);
        }
    }

    private Segment getLegendSegment(int row) {
        if (this.legendSegmentOrder == null) {
            return this.segments.get(row);
        }
        return this.segments.get(this.legendSegmentOrder[row]);
    }

    private void drawLegendLine(Graphics2D g2, int verticalOffset, double horizontalNumberOffset, Color col, String txt, String numberText, boolean textIsPlural, boolean withSubSegment, String subSegmentText, String subNumberText, boolean subTextIsPlural) {
        int left = 620;
        if (col != null) {
            g2.drawImage(this.keyShadow.getImage(), left, 30 + verticalOffset, this.keyShadow.getImageObserver());
            g2.setColor(col);
            g2.fillRect(left + 13, 37 + verticalOffset, 45, 45);
            if (withSubSegment) {
                Polygon p = new Polygon(new int[]{left + 13 + 45, left + 13 + 45, left + 13}, new int[]{verticalOffset + 37, verticalOffset + 37 + 45, verticalOffset + 37 + 45}, 3);
                g2.setColor(col.darker());
                g2.fillPolygon(p);
            }
        }
        g2.setColor(Color.BLACK);
        StringBuffer sb = new StringBuffer(numberText);
        sb.append("  ").append(PieChart.plural(textIsPlural, txt));
        if (withSubSegment) {
            sb.append(" with ");
            sb.append(subNumberText);
            sb.append(" ");
            sb.append(PieChart.plural(subTextIsPlural, subSegmentText));
        }
        g2.drawString(sb.toString(), (int)((double)(left + 80) + horizontalNumberOffset), 71 + verticalOffset);
    }

    private Arc2D paintPieSegment(Graphics2D g2, double startRatio, double endRatio, Color fillColor) {
        return this.paintPieSegment(g2, startRatio, endRatio, 263.0, fillColor);
    }

    private Arc2D paintPieSegment(Graphics2D g2, double startRatio, double endRatio, double radius, Color fillColor) {
        Arc2D.Double pie = new Arc2D.Double(2);
        double startAngle = 90.0 - 360.0 * startRatio;
        double endAngle = -360.0 * endRatio;
        pie.setArcByCenter(296.0, 287.0, radius, startAngle, endAngle, 2);
        g2.setColor(fillColor);
        g2.fill(pie);
        return pie;
    }

    private static final String removeSuffix(String text, String suffix) {
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    private static final String plural(boolean plural, CharSequence text) {
        StringBuilder b = new StringBuilder();
        int mode = 0;
        block5: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (mode) {
                case 0: {
                    if (c == '{') {
                        mode = 1;
                        continue block5;
                    }
                    b.append(c);
                    continue block5;
                }
                case 1: {
                    if (c == '|') {
                        mode = 2;
                        continue block5;
                    }
                    if (plural) continue block5;
                    b.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '}') {
                        mode = 0;
                        continue block5;
                    }
                    if (!plural) continue block5;
                    b.append(c);
                    continue block5;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return b.toString();
    }

    public static class Segment {
        private final String text;
        private final String subSegmentText;
        private final Color color;
        private final double portion;
        private final double subPortion;
        private final double subSegmentRatio;
        private String percent = null;

        public Segment(String text, double portion, Color color) {
            this(text, null, portion, 0.0, color);
        }

        public Segment(String text, String subSegmentText, double portion, double subPortion, Color color) throws IllegalArgumentException {
            assert (portion >= 0.0 && subPortion >= 0.0 && portion >= subPortion);
            this.text = text;
            this.subSegmentText = subSegmentText;
            this.portion = portion;
            this.subPortion = subPortion;
            this.subSegmentRatio = portion > 0.0 ? subPortion / portion : 0.0;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public String getSubSegmentText() {
            return this.subSegmentText;
        }

        public double getPortion() {
            return this.portion;
        }

        public double getSubPortion() {
            return this.subPortion;
        }

        public double getSubSegmentRatio() {
            return this.subSegmentRatio;
        }

        public Color getColor() {
            return this.color;
        }

        public String getPercent() {
            return this.percent;
        }

        public void setPercent(String percent) {
            this.percent = percent;
        }
    }
}

