/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.publisher;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class OpenReportForFailedTestAction
implements Action,
StaplerProxy {
    private String name;
    private String reportFile;
    private AbstractBuild<?, ?> build;
    private String id;
    private String executionConfiguration;
    private String date;
    private String platform;

    public OpenReportForFailedTestAction(AbstractBuild<?, ?> build, String fileName, String reportFile, String id, String exConfig, String platform, String date) {
        this.id = id;
        this.name = fileName;
        this.platform = platform;
        this.executionConfiguration = exConfig;
        this.build = build;
        this.reportFile = reportFile;
        this.date = date;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return this.name + this.executionConfiguration + this.id + this.date;
    }

    public Object getTarget() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        File indexFromFile = new File(this.build.getRootDir().getAbsolutePath() + File.separator + "Piketec-TPT" + File.separator + this.name + File.separator + this.executionConfiguration + File.separator + "index.html");
        String indexFromFileAsString = FileUtils.readFileToString((File)indexFromFile);
        String failedHtmlAsString = indexFromFileAsString.replace("overview.html", this.reportFile);
        File failedHTML = new File(this.build.getRootDir().getAbsolutePath() + File.separator + "Piketec-TPT" + File.separator + this.name + File.separator + this.executionConfiguration + File.separator + "failedTest.html");
        FileUtils.writeStringToFile((File)failedHTML, (String)failedHtmlAsString);
        DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(new File(this.build.getRootDir().getAbsolutePath() + File.separator + "Piketec-TPT" + File.separator + this.name + File.separator + this.executionConfiguration)), "TPT Report", "clipboard.png", false);
        if (req.getRestOfPath().equals("")) {
            throw HttpResponses.forwardToView((Object)this, (String)"index.jelly");
        }
        dbs.generateResponse(req, rsp, (Object)this);
    }

    public String getExecutionConfiguration() {
        return this.executionConfiguration;
    }

    public void setExecutionConfiguration(String executionConfiguration) {
        this.executionConfiguration = executionConfiguration;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }
}

