/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import hudson.FilePath;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class XmlStreamWriter {
    private XMLStreamWriter writer;
    private OutputStream os;
    private BufferedOutputStream bos;

    XmlStreamWriter() {
    }

    public void initalize(FilePath file) throws XMLStreamException, FactoryConfigurationError, IOException, InterruptedException {
        this.os = file.write();
        this.bos = new BufferedOutputStream(this.os);
        this.writer = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(this.bos, "UTF-8"));
        this.writer.writeStartDocument("UTF-8", "1.0");
    }

    public void writeTestsuite(String name) throws XMLStreamException {
        this.writer.writeStartElement("testsuite");
        this.writer.writeAttribute("name", name);
        this.writer.flush();
    }

    public void writeTestcase(String classname, String testname, String timeMillis) throws XMLStreamException {
        this.writer.writeStartElement("testcase");
        this.writer.writeAttribute("classname", classname);
        this.writer.writeAttribute("name", testname);
        this.writer.writeAttribute("time", this.millis2secs(timeMillis));
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void writeTestcaseError(String classname, String testname, String timeMillis, String error) throws XMLStreamException {
        this.writer.writeStartElement("testcase");
        this.writer.writeAttribute("classname", classname);
        this.writer.writeAttribute("name", testname);
        this.writer.writeAttribute("time", this.millis2secs(timeMillis));
        this.writer.writeStartElement("error");
        this.writer.writeAttribute("message", error);
        this.writer.writeEndElement();
        this.writer.flush();
        this.writer.writeEndElement();
        this.writer.flush();
    }

    private String millis2secs(String t) {
        try {
            return Double.toString((double)Long.parseLong(t) / 1000.0);
        }
        catch (NumberFormatException e) {
            return t;
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.writeEndElement();
                this.writer.flush();
                this.writer.writeEndDocument();
                this.writer.flush();
                this.writer.close();
                this.bos.close();
                this.os.close();
            }
            catch (XMLStreamException xe) {
                xe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.writer = null;
                this.bos = null;
                this.os = null;
            }
        }
    }
}

