/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

public class WorkLoad {
    private static HashMap<String, LinkedList<WorkLoad>> workloads = new HashMap();
    private String fileName;
    private String dataDir;
    private String reportDir;
    private String testSetName;
    private String exeConfig;
    private List<String> testCases;
    private AbstractBuild masterId;
    private FilePath masterWorkspace;

    public WorkLoad(String fileName, String exeConfig, String dataDir, String reportDir, String testSetName, List<String> testCases, FilePath masterWorkspace, AbstractBuild masterId) {
        this.fileName = fileName;
        this.exeConfig = exeConfig;
        this.dataDir = dataDir;
        this.reportDir = reportDir;
        this.testSetName = testSetName;
        this.testCases = testCases;
        this.masterId = masterId;
        this.masterWorkspace = masterWorkspace;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getTestSetName() {
        return this.testSetName;
    }

    public String getExeConfig() {
        return this.exeConfig;
    }

    public List<String> getTestCases() {
        return this.testCases;
    }

    public FilePath getMasterWorkspace() {
        return this.masterWorkspace;
    }

    public AbstractBuild getMasterId() {
        return this.masterId;
    }

    public static synchronized void putWorkLoad(String jobName, WorkLoad workloadToAdd) {
        LinkedList<WorkLoad> queue = workloads.get(jobName);
        if (queue == null) {
            queue = new LinkedList();
            workloads.put(jobName, queue);
        }
        if (!queue.contains(workloadToAdd)) {
            queue.offer(workloadToAdd);
        }
    }

    public static synchronized WorkLoad pollWorkload(String jobName) {
        Queue queue = workloads.get(jobName);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        return (WorkLoad)queue.poll();
    }

    public static synchronized void clean(String jobName, AbstractBuild masterBuild) {
        LinkedList<WorkLoad> queue = workloads.get(jobName);
        if (queue == null) {
            return;
        }
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            WorkLoad next = (WorkLoad)iterator.next();
            if (!Objects.equals(next.masterId, masterBuild)) continue;
            iterator.remove();
        }
        if (queue.isEmpty()) {
            workloads.remove(jobName);
        }
    }
}

