/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.CleanUpTask;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.ExecutionConfiguration;
import com.piketec.tpt.api.ExecutionConfigurationItem;
import com.piketec.tpt.api.ExecutionStatus;
import com.piketec.tpt.api.OpenResult;
import com.piketec.tpt.api.Scenario;
import com.piketec.tpt.api.ScenarioGroup;
import com.piketec.tpt.api.ScenarioOrGroup;
import com.piketec.tpt.api.TestSet;
import com.piketec.tpt.api.TptApi;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class TptPluginSlaveExecutor {
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private int tptPort;
    private String tptBindingName;
    private File tptFile;
    private String execCfg;
    private String testDataDir;
    private String reportDir;
    private List<String> testSetString;
    private long tptStartupWaitTime;
    private AbstractBuild masterId;
    private String testSetName;
    private FilePath masterWorkspace;

    TptPluginSlaveExecutor(Launcher launcher, AbstractBuild<?, ?> build, BuildListener listener, FilePath[] exePaths, int tptPort, String tptBindingName, File tptFile, String execCfg, String testDataDir, String reportDir, List<String> testSet, long tptStartupWaitTime, AbstractBuild masterId, String testSetName, FilePath masterWorkspace) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.tptPort = tptPort;
        this.tptBindingName = tptBindingName;
        this.tptFile = tptFile;
        this.execCfg = execCfg;
        this.testDataDir = testDataDir;
        this.reportDir = reportDir;
        this.testSetString = testSet;
        this.tptStartupWaitTime = tptStartupWaitTime;
        this.masterId = masterId;
        this.testSetName = testSetName;
        this.masterWorkspace = masterWorkspace;
    }

    public boolean execute() {
        this.logger = new TptLogger(this.listener.getLogger());
        try {
            TptApi api;
            try {
                api = Utils.getTptApi(this.build, this.launcher, this.logger, this.exePaths, this.tptPort, this.tptBindingName, this.tptStartupWaitTime);
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            if (api == null) {
                return false;
            }
            OpenResult openProject = api.openProject(this.tptFile);
            if (openProject.getProject() == null) {
                this.logger.error("Could not open project:\n" + Utils.toString(openProject.getLogs(), "\n"));
                return false;
            }
            new CleanUpTask(openProject.getProject(), this.masterId);
            Collection<ExecutionConfiguration> execConfigs = openProject.getProject().getExecutionConfigurations().getItems();
            ExecutionConfiguration config = null;
            for (ExecutionConfiguration elem : execConfigs) {
                if (!elem.getName().equals(this.execCfg)) continue;
                config = elem;
                break;
            }
            if (config == null) {
                this.logger.error("Could not find config");
                return false;
            }
            File oldReportDir = config.getReportDir();
            File oldTestDataDir = config.getDataDir();
            HashSet<Scenario> foundScenearios = new HashSet<Scenario>();
            this.find(openProject.getProject().getTopLevelTestlet().getTopLevelScenarioOrGroup().getItems(), this.testSetString, foundScenearios);
            if (foundScenearios.size() != this.testSetString.size()) {
                this.logger.error("Could only find " + foundScenearios.size() + " of " + this.testSetString.size() + ".");
                return false;
            }
            FilePath slaveDataDir = null;
            FilePath slaveReportDir = null;
            try {
                slaveDataDir = new FilePath(this.build.getWorkspace(), this.testDataDir).absolutize();
                if (!this.masterWorkspace.equals((Object)this.build.getWorkspace())) {
                    this.logger.info("Creating and/or cleaning test data directory");
                    Utils.deleteFiles(slaveDataDir);
                }
            }
            catch (IOException e) {
                this.logger.error("Could not create or clear test data dir");
                return false;
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            this.logger.info("Setting test data directory to " + slaveDataDir.getRemote());
            config.setDataDir(new File(slaveDataDir.getRemote()));
            try {
                slaveReportDir = new FilePath(this.build.getWorkspace(), this.reportDir).absolutize();
                if (!this.masterWorkspace.equals((Object)this.build.getWorkspace())) {
                    this.logger.info("Creating and/or cleaning report directory");
                    slaveReportDir.mkdirs();
                    slaveReportDir.deleteContents();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
                config.setDataDir(oldTestDataDir);
                return false;
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                config.setDataDir(oldTestDataDir);
                return false;
            }
            this.logger.info("Setting report directory to " + slaveReportDir.getRemote());
            config.setReportDir(new File(slaveReportDir.getRemote()));
            ArrayList<TestSet> oldTestSets = new ArrayList<TestSet>();
            ArrayList<TestSet> newTestSets = new ArrayList<TestSet>();
            ArrayList<ExecutionConfigurationItem> deactivated = new ArrayList<ExecutionConfigurationItem>();
            int i = 0;
            if (StringUtils.isEmpty((String)this.testSetName)) {
                for (ExecutionConfigurationItem item : config.getItems()) {
                    oldTestSets.add(item.getTestSet());
                    if (!item.isActive()) continue;
                    Collection<Scenario> intersectionSet = TptPluginSlaveExecutor.intersectByHash(item.getTestSet().getTestCases().getItems(), foundScenearios);
                    if (intersectionSet.isEmpty()) {
                        item.setActive(false);
                        deactivated.add(item);
                        continue;
                    }
                    String tmpTestSetName = "JENKINS Exec " + i;
                    ++i;
                    this.logger.info("Create test set \"" + tmpTestSetName + "\" for execution of \"" + this.remoteScenarioSetToString(intersectionSet) + "\"");
                    TestSet testSet = openProject.getProject().createTestSet(tmpTestSetName);
                    newTestSets.add(testSet);
                    Iterator iterator = intersectionSet.iterator();
                    while (iterator.hasNext()) {
                        Scenario scen = (Scenario)iterator.next();
                        testSet.addTestCase(scen);
                    }
                    item.setTestSet(testSet);
                }
            } else {
                String tmpTestSetName = "JENKINS Exec " + this.testSetName;
                this.logger.info("Create test set \"" + tmpTestSetName + "\" for execution of \"" + this.remoteScenarioSetToString(foundScenearios) + "\" from File " + this.tptFile.getName());
                TestSet testSet = openProject.getProject().createTestSet(tmpTestSetName);
                newTestSets.add(testSet);
                for (Scenario scen : foundScenearios) {
                    testSet.addTestCase(scen);
                }
                for (ExecutionConfigurationItem item : config.getItems()) {
                    oldTestSets.add(item.getTestSet());
                    if (!item.isActive()) continue;
                    item.setTestSet(testSet);
                }
            }
            ExecutionStatus execStatus = api.run(config);
            while (execStatus.isRunning() || execStatus.isPending()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    execStatus.cancel();
                    break;
                }
            }
            this.logger.info("Set test sets in execution config to old values.");
            for (ExecutionConfigurationItem item : config.getItems()) {
                item.setTestSet((TestSet)oldTestSets.remove(0));
            }
            try {
                slaveDataDir.copyRecursiveTo(new FilePath(this.masterWorkspace, this.testDataDir));
                slaveReportDir.copyRecursiveTo(new FilePath(this.masterWorkspace, this.reportDir));
                this.logger.info("Copied all data to master from File " + this.tptFile.getName() + " to " + this.masterWorkspace.getRemote());
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            catch (IOException e) {
                this.logger.error("could not copy results to master: " + e.getMessage());
            }
            this.logger.info("reset test data and report directory to " + oldTestDataDir.getPath() + " and " + oldReportDir.getPath());
            config.setDataDir(oldTestDataDir);
            config.setReportDir(oldReportDir);
            for (TestSet testSet : newTestSets) {
                this.logger.info("delete temporary test set \"" + testSet.getName() + "\"");
                openProject.getProject().getTestSets().delete(testSet);
            }
            this.logger.info("Reactivate temporary deactivated execution config items.");
            for (ExecutionConfigurationItem item : deactivated) {
                item.setActive(true);
            }
        }
        catch (RemoteException e) {
            this.logger.error(e.getLocalizedMessage());
            e.printStackTrace(this.logger.getLogger());
            return false;
        }
        catch (ApiException e) {
            this.logger.error(e.getLocalizedMessage());
            e.printStackTrace(this.logger.getLogger());
            return false;
        }
        return true;
    }

    private void find(Collection<ScenarioOrGroup> sogs, Collection<String> names, Collection<Scenario> result) throws RemoteException, ApiException {
        for (ScenarioOrGroup sog : sogs) {
            if (sog instanceof Scenario) {
                if (!names.contains(sog.getName())) continue;
                result.add((Scenario)sog);
                continue;
            }
            this.find(((ScenarioGroup)sog).getItems(), names, result);
        }
    }

    static Collection<Scenario> intersectByHash(Collection<Scenario> scenColl1, Collection<Scenario> scenCol2) throws RemoteException, ApiException {
        HashSet<String> scenCol1Names = new HashSet<String>();
        ArrayList<Scenario> result = new ArrayList<Scenario>();
        for (Scenario scen : scenColl1) {
            scenCol1Names.add(scen.getName());
        }
        for (Scenario scen : scenCol2) {
            if (!scenCol1Names.contains(scen.getName())) continue;
            result.add(scen);
        }
        return result;
    }

    private String remoteScenarioSetToString(Collection<Scenario> intersectionSet) throws RemoteException, ApiException {
        StringBuilder sb = new StringBuilder();
        for (Scenario scen : intersectionSet) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(scen.getName());
        }
        return sb.toString();
    }
}

