/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.TptPluginSlaveExecutor;
import com.piketec.jenkins.plugins.tpt.WorkLoad;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class TptPluginSlave
extends Builder {
    private String exePaths;
    private String tptBindingName;
    private String tptPort;
    private String tptStartUpWaitTime;

    @DataBoundConstructor
    public TptPluginSlave(String exePaths, String tptBindingName, String tptPort, String tptStartUpWaitTime) {
        this.exePaths = exePaths;
        this.tptBindingName = tptBindingName;
        this.tptPort = tptPort;
        this.tptStartUpWaitTime = tptStartUpWaitTime;
    }

    public String getExePaths() {
        return this.exePaths;
    }

    public String getTptBindingName() {
        return this.tptBindingName;
    }

    public String getTptPort() {
        return this.tptPort;
    }

    public String getTptStartUpWaitTime() {
        return this.tptStartUpWaitTime;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TptPluginSlaveExecutor executor;
        boolean result;
        String jobName;
        WorkLoad workloadToDo;
        long expandedTptStartupWaitTime;
        int expandedTptPort;
        EnvVars environment;
        TptLogger logger = new TptLogger(listener.getLogger());
        try {
            environment = build.getEnvironment(launcher.getListener());
        }
        catch (IOException e) {
            environment = new EnvVars();
            logger.error(e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getLocalizedMessage());
            return false;
        }
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launcher.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        if (this.tptPort != null && !this.tptPort.isEmpty()) {
            try {
                expandedTptPort = Integer.parseInt(environment.expand(this.tptPort));
            }
            catch (NumberFormatException e) {
                logger.error("The given port " + environment.expand(this.tptPort) + " is not an integer." + " Using default value.");
                expandedTptPort = DescriptorImpl.getDefaultTptPort();
            }
        } else {
            expandedTptPort = DescriptorImpl.getDefaultTptPort();
        }
        String expandedTptBindingName = this.tptBindingName != null && !this.tptBindingName.isEmpty() ? environment.expand(this.tptBindingName) : DescriptorImpl.getDefaultTptBindingName();
        if (this.tptStartUpWaitTime != null && !this.tptStartUpWaitTime.isEmpty()) {
            try {
                expandedTptStartupWaitTime = Integer.parseInt(environment.expand(this.tptStartUpWaitTime)) * 1000;
            }
            catch (NumberFormatException e) {
                logger.error("The given TPT startup waiting time " + environment.expand(this.tptStartUpWaitTime) + " is not an integer. Using default value.");
                expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
            }
        } else {
            expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
        }
        if ((workloadToDo = WorkLoad.pollWorkload(jobName = build.getProject().getName())) == null) {
            logger.error("Nothing todo. No work package for \"" + jobName + "\" enqueued.");
            return false;
        }
        String fileNameFromWorkload = workloadToDo.getFileName();
        String exeConfigFromWorkload = workloadToDo.getExeConfig();
        String testDataDirFromWorload = workloadToDo.getDataDir();
        String reportDirFromWorkload = workloadToDo.getReportDir();
        List<String> testCasesFromWorkload = workloadToDo.getTestCases();
        String testSetFromWorkload = workloadToDo.getTestSetName();
        AbstractBuild masterId = workloadToDo.getMasterId();
        FilePath masterWorkspace = workloadToDo.getMasterWorkspace();
        logger.info("File Name :               " + fileNameFromWorkload);
        logger.info("Execution Configuration : " + exeConfigFromWorkload);
        logger.info("Test Data directory :     " + testDataDirFromWorload);
        logger.info("Report directory :        " + reportDirFromWorkload);
        logger.info("Test Cases :              " + testCasesFromWorkload);
        if (StringUtils.isNotEmpty((String)testSetFromWorkload)) {
            logger.info("Test Set :                " + testSetFromWorkload);
        }
        if (!(result = (executor = new TptPluginSlaveExecutor(launcher, build, listener, expandedExePaths, expandedTptPort, expandedTptBindingName, new File(fileNameFromWorkload), exeConfigFromWorkload, testDataDirFromWorload, reportDirFromWorkload, testCasesFromWorkload, expandedTptStartupWaitTime, masterId, testSetFromWorkload, masterWorkspace)).execute())) {
            WorkLoad.putWorkLoad(jobName, workloadToDo);
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute TPT tests slave";
        }

        public static String getDefaultExePaths() {
            return "${PIKETEC_TPT_EXE}";
        }

        public static String getDefaultTptBindingName() {
            return "TptApi";
        }

        public static int getDefaultTptPort() {
            return 1099;
        }

        public static int getDefaultTptStartUpWaitTime() {
            return 60;
        }
    }
}

