/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.TPTBuildStepEntries;
import com.piketec.jenkins.plugins.tpt.TptLog;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

class TptPluginSingleJobExecutor {
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private String arguments;
    private List<JenkinsConfiguration> executionConfigs;
    private String jUnitXmlPath;
    private TptLog.LogLevel jUnitLogLevel;
    private boolean enableJunit;

    TptPluginSingleJobExecutor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, FilePath[] exePaths, String arguments, List<JenkinsConfiguration> executionConfigs, String jUnitXmlPath, TptLog.LogLevel jUnitLogLevel, boolean enableJunit) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.arguments = arguments;
        this.executionConfigs = executionConfigs;
        this.jUnitXmlPath = jUnitXmlPath;
        this.jUnitLogLevel = jUnitLogLevel;
        this.enableJunit = enableJunit;
    }

    boolean execute() {
        File workspaceDir;
        boolean success = true;
        FilePath workspace = this.build.getWorkspace();
        try {
            workspaceDir = Utils.getWorkspaceDir(workspace, this.logger);
        }
        catch (InterruptedException e) {
            this.logger.interrupt(e.getMessage());
            return false;
        }
        FilePath exeFile = null;
        for (FilePath f : this.exePaths) {
            try {
                if (!f.exists()) continue;
                exeFile = f;
                break;
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
        }
        if (exeFile == null) {
            this.logger.error("No TPT installation found");
            return false;
        }
        for (JenkinsConfiguration ec : this.executionConfigs) {
            if (!ec.isEnableTest()) continue;
            String testdataDir = Utils.getGeneratedTestDataDir(ec);
            FilePath testDataPath = new FilePath(this.build.getWorkspace(), testdataDir);
            String reportDir = Utils.getGeneratedReportDir(ec);
            FilePath reportPath = new FilePath(this.build.getWorkspace(), reportDir);
            File tptFile = Utils.getAbsolutePath(workspaceDir, new File(ec.getTptFile()));
            String configurationName = ec.getConfiguration();
            String tesSet = ec.getTestSet();
            this.logger.info("*** Running TPT-File \"" + tptFile + "\" with configuration \"" + configurationName + "\" now. ***");
            if (Utils.createParentDir(new File(testdataDir), workspace) && Utils.createParentDir(new File(reportDir), workspace)) {
                String cmd = this.buildCommand(exeFile, this.arguments, tptFile, testDataPath.getRemote(), reportPath.getRemote(), configurationName, tesSet);
                try {
                    boolean successOnlyForOneConfig = this.launchTPT(this.launcher, this.listener, cmd, ec.getTimeout());
                    success &= successOnlyForOneConfig;
                    if (successOnlyForOneConfig) {
                        TPTBuildStepEntries.addEntry(ec, this.build);
                    }
                    if (!this.enableJunit) continue;
                    this.logger.info("*** Publishing results now ***");
                    Utils.publishAsJUnitResults(workspace, ec, testDataPath, this.jUnitXmlPath, this.jUnitLogLevel, this.logger);
                    continue;
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                    success = false;
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    return false;
                }
            }
            this.logger.error("Failed to create parent directories for " + testdataDir + " and/or " + reportDir);
            success = false;
        }
        return success;
    }

    private String buildCommand(FilePath exeFile, String arguments, File tptFile, String dataDir, String reportDir, String configurationName, String testSet) {
        StringBuilder cmd = new StringBuilder();
        String exeString = exeFile.getRemote();
        if (!exeString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(exeString);
        if (!exeString.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(' ');
        cmd.append(arguments);
        cmd.append(' ');
        String tptFileString = tptFile.toString();
        if (!tptFileString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(tptFileString);
        if (!tptFileString.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(' ');
        if (!configurationName.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(configurationName);
        if (!configurationName.endsWith("\"")) {
            cmd.append('\"');
        }
        if (StringUtils.isNotEmpty((String)testSet)) {
            cmd.append(" --testSet ");
            if (!testSet.startsWith("\"")) {
                cmd.append('\"');
            }
            cmd.append(testSet);
            if (!testSet.endsWith("\"")) {
                cmd.append('\"');
            }
            this.logger.info("Running " + testSet);
        }
        cmd.append(" --dataDir ");
        if (!dataDir.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(dataDir);
        if (!dataDir.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(" --reportDir ");
        if (!reportDir.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(reportDir);
        if (!reportDir.endsWith("\"")) {
            cmd.append('\"');
        }
        return cmd.toString();
    }

    private boolean launchTPT(Launcher launcher, BuildListener listener, String cmd, long timeout) throws InterruptedException, IOException {
        boolean exitCodeWasNull = true;
        this.logger.info("Launching \"" + cmd + "\"");
        Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher);
        starter.cmdAsSingleString(cmd);
        starter.stdout((OutputStream)this.logger.getLogger());
        starter.stderr((OutputStream)this.logger.getLogger());
        Proc tpt = null;
        try {
            tpt = starter.start();
            if (timeout <= 0L) {
                timeout = JenkinsConfiguration.DescriptorImpl.getDefaultTimeout();
            }
            this.logger.info("Waiting for TPT to complete. Timeout: " + timeout + "h");
            int exitcode = tpt.joinWithTimeout(timeout, TimeUnit.HOURS, (TaskListener)listener);
            if (exitcode != 0) {
                this.logger.error("TPT process stops with exit code " + exitcode);
                exitCodeWasNull = false;
            }
        }
        catch (IOException e) {
            throw new IOException("TPT launch error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            try {
                tpt.kill();
            }
            catch (IOException | InterruptedException e1) {
                throw new IOException("TPT launch error: Interrupt requested, but cannot kill the TPT process. Please kill it manually.");
            }
            throw e;
        }
        return exitCodeWasNull;
    }
}

