/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.CleanUpTask;
import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.Publish;
import com.piketec.jenkins.plugins.tpt.RetryableJob;
import com.piketec.jenkins.plugins.tpt.TPTBuildStepEntries;
import com.piketec.jenkins.plugins.tpt.TptLog;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.jenkins.plugins.tpt.WorkLoad;
import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.ExecutionConfiguration;
import com.piketec.tpt.api.ExecutionConfigurationItem;
import com.piketec.tpt.api.ExecutionStatus;
import com.piketec.tpt.api.OpenResult;
import com.piketec.tpt.api.Project;
import com.piketec.tpt.api.RemoteCollection;
import com.piketec.tpt.api.Scenario;
import com.piketec.tpt.api.TestSet;
import com.piketec.tpt.api.TptApi;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Job;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

class TptPluginMasterJobExecutor {
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private List<JenkinsConfiguration> executionConfigs;
    private int tptPort;
    private String tptBindingName;
    private String slaveJobName;
    private long tptStartupWaitTime;
    private int slaveJobCount;
    private int slaveJobTries;
    private String jUnitXmlPath;
    private TptLog.LogLevel jUnitLogLevel;
    private boolean enableJunit;

    TptPluginMasterJobExecutor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, FilePath[] exePaths, List<JenkinsConfiguration> executionConfigs, int tptPort, String tptBindingName, String slaveJobName, long tptStartupWaitTime, int slaveJobCount, int slaveJobTries, String jUnitXmlPath, TptLog.LogLevel jUnitLogLevel, boolean enableJunit) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.executionConfigs = executionConfigs;
        this.tptPort = tptPort;
        this.tptBindingName = tptBindingName;
        this.slaveJobName = slaveJobName;
        this.tptStartupWaitTime = tptStartupWaitTime;
        this.slaveJobCount = slaveJobCount;
        this.slaveJobTries = slaveJobTries;
        this.jUnitLogLevel = jUnitLogLevel;
        this.jUnitXmlPath = jUnitXmlPath;
        this.enableJunit = enableJunit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute() {
        TptApi api = null;
        boolean success = true;
        try {
            api = Utils.getTptApi(this.build, this.launcher, this.logger, this.exePaths, this.tptPort, this.tptBindingName, this.tptStartupWaitTime);
            if (api == null) {
                boolean bl = false;
                return bl;
            }
            if (!StringUtils.isBlank((String)this.jUnitXmlPath)) {
                FilePath path = new FilePath(this.build.getWorkspace(), this.jUnitXmlPath);
                this.logger.info("Create and/or clear JUnit XML directory " + path.getRemote());
                try {
                    path.mkdirs();
                    path.deleteContents();
                }
                catch (IOException e) {
                    this.logger.error("Could not create and/or clear JUnit XML directory " + path.getRemote());
                }
            }
            for (JenkinsConfiguration ec : this.executionConfigs) {
                success &= this.executeOneConfig(ec, api);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.interrupt(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.logger.info("Close open TPT project on master and slaves.");
            if (!CleanUpTask.cleanUp(this.build)) {
                this.logger.error("Could not close all open TPT files. There is no guarantee next run will be be done with correct file version.");
                return false;
            }
        }
        return success;
    }

    /*
     * WARNING - void declaration
     */
    private boolean executeOneConfig(JenkinsConfiguration ec, TptApi api) throws InterruptedException {
        int remainer;
        int slaveJobSize;
        ExecutionConfiguration executionConfig;
        OpenResult openProject;
        if (!ec.isEnableTest()) {
            return true;
        }
        Collection<String> testCases = null;
        String testdataDir = Utils.getGeneratedTestDataDir(ec);
        FilePath testDataPath = new FilePath(this.build.getWorkspace(), testdataDir);
        String reportDir = Utils.getGeneratedReportDir(ec);
        FilePath reportPath = new FilePath(this.build.getWorkspace(), reportDir);
        try {
            this.logger.info("Create and/or clean test data directory \"" + testDataPath.getRemote() + "\"");
            testDataPath.mkdirs();
            Utils.deleteFiles(testDataPath);
            this.logger.info("Create and/or clean report directory \"" + reportPath.getRemote() + "\"");
            reportPath.mkdirs();
            reportPath.deleteContents();
        }
        catch (IOException e) {
            this.logger.error("Could not create or clear directories on master: " + e.getMessage());
            return false;
        }
        try {
            openProject = api.openProject(new File(ec.getTptFile()));
            if (openProject.getProject() == null) {
                this.logger.error("Could not open project:\n" + Utils.toString(openProject.getLogs(), "\n"));
                return false;
            }
            new CleanUpTask(openProject.getProject(), this.build);
            executionConfig = this.getExecutionConfigByName(openProject.getProject(), ec.getConfiguration());
            if (executionConfig == null) {
                this.logger.error("Could not find config");
                return false;
            }
            if (StringUtils.isNotEmpty((String)ec.getTestSet())) {
                boolean testSetFound = false;
                for (TestSet definedTestset : openProject.getProject().getTestSets().getItems()) {
                    if (!definedTestset.getName().equals(ec.getTestSet())) continue;
                    testSetFound = true;
                    testCases = new ArrayList<String>();
                    for (Scenario testcase : definedTestset.getTestCases().getItems()) {
                        testCases.add(testcase.getName());
                    }
                }
                if (!testSetFound) {
                    this.logger.error("Could not find test set \"" + ec.getTestSet() + "\"");
                    return false;
                }
            } else {
                testCases = this.getTestCaseNames(executionConfig);
            }
        }
        catch (RemoteException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        catch (ApiException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        if (testCases == null || testCases.isEmpty()) {
            this.logger.error("No test cases are found to execute. It is possible that \"selected Test Cases \" is configured as test set. If so please change it to another existing test set");
            return false;
        }
        ArrayList<Object> retryableJobs = new ArrayList<Object>();
        if (this.slaveJobCount > 1) {
            slaveJobSize = testCases.size() / this.slaveJobCount;
            remainer = testCases.size() % this.slaveJobCount;
        } else {
            slaveJobSize = testCases.size();
            remainer = 0;
        }
        ArrayList<List<String>> subTestSets = this.getSubTestSets(testCases, slaveJobSize, remainer);
        Job slaveJob = null;
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance == null) {
            this.logger.error("No jenkins instance found");
            return false;
        }
        for (Job job : jenkinsInstance.getAllItems(Job.class)) {
            if (!job.getName().equals(this.slaveJobName)) continue;
            slaveJob = job;
        }
        if (slaveJob == null) {
            this.logger.error("Slave Job \"" + this.slaveJobName + "\" not found");
            return false;
        }
        for (List list : subTestSets) {
            this.logger.info("Create job for \"" + list + "\"");
            WorkLoad workloadToAdd = new WorkLoad(ec.getTptFile(), ec.getConfiguration(), testdataDir, reportDir, ec.getTestSet(), list, this.build.getWorkspace(), this.build);
            WorkLoad.putWorkLoad(this.slaveJobName, workloadToAdd);
            RetryableJob retryableJob = new RetryableJob(this.slaveJobTries, this.logger, slaveJob);
            retryableJob.perform(this.build, this.listener);
            retryableJobs.add(retryableJob);
        }
        this.logger.info("Waiting for completion of child jobs.");
        for (RetryableJob retryableJob : retryableJobs) {
            try {
                retryableJob.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.interrupt(e.getMessage());
                this.logger.info("Stopping slave jobs.");
                for (RetryableJob retryableJob2 : retryableJobs) {
                    retryableJob2.cancel();
                }
                return false;
            }
        }
        try {
            void var20_45;
            File oldTestDataFile = executionConfig.getDataDir();
            File file = executionConfig.getReportDir();
            executionConfig.setDataDir(new File(testDataPath.getRemote()));
            executionConfig.setReportDir(new File(reportPath.getRemote()));
            ArrayList<TestSet> oldTestSets = new ArrayList<TestSet>();
            if (StringUtils.isNotEmpty((String)ec.getTestSet())) {
                void var20_37;
                RemoteCollection<TestSet> allTestSets = openProject.getProject().getTestSets();
                Object var20_36 = null;
                for (TestSet t : allTestSets.getItems()) {
                    if (!t.getName().equals(ec.getTestSet())) continue;
                    TestSet testSet = t;
                }
                if (var20_37 == null) {
                    this.logger.error("Test set \"" + ec.getTestSet() + "\" not found.");
                    return false;
                }
                for (ExecutionConfigurationItem item : executionConfig.getItems()) {
                    oldTestSets.add(item.getTestSet());
                    item.setTestSet((TestSet)var20_37);
                }
            }
            ExecutionStatus execStatus = api.reGenerateOverviewReport(executionConfig);
            while (execStatus.isRunning() || execStatus.isPending()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    execStatus.cancel();
                    return false;
                }
            }
            executionConfig.setDataDir(oldTestDataFile);
            executionConfig.setReportDir(file);
            if (StringUtils.isNotEmpty((String)ec.getTestSet())) {
                for (ExecutionConfigurationItem item : executionConfig.getItems()) {
                    item.setTestSet((TestSet)oldTestSets.remove(0));
                }
            }
            boolean bl = false;
            if (this.enableJunit) {
                int n = Utils.publishAsJUnitResults(this.build.getWorkspace(), ec, testDataPath, this.jUnitXmlPath, this.jUnitLogLevel, this.logger);
            } else {
                try {
                    int n = Publish.getTestcases(testDataPath, this.logger).size();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.interrupt("Interrupted while parsing the \"test_summary.xml\" of the testcases.");
                    return false;
                }
            }
            if (var20_45 != testCases.size()) {
                this.logger.error("Found only " + (int)var20_45 + " of " + testCases.size() + " test results.");
                return false;
            }
        }
        catch (RemoteException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        catch (ApiException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.logger.error("Could not publish result: " + e.getMessage());
            return false;
        }
        TPTBuildStepEntries.addEntry(ec, this.build);
        return true;
    }

    private ArrayList<List<String>> getSubTestSets(Collection<String> testCases, int slaveJobSize, int remainer) {
        ArrayList<List<String>> testSets = new ArrayList<List<String>>();
        ArrayList<String> currentTestSet = new ArrayList<String>();
        Iterator<String> iterator = testCases.iterator();
        while (iterator.hasNext()) {
            currentTestSet.add(iterator.next());
            if (currentTestSet.size() != slaveJobSize) continue;
            if (remainer > 0) {
                assert (iterator.hasNext());
                if (iterator.hasNext()) {
                    currentTestSet.add(iterator.next());
                }
                --remainer;
            }
            testSets.add(currentTestSet);
            currentTestSet = new ArrayList();
        }
        if (!currentTestSet.isEmpty()) {
            testSets.add(currentTestSet);
        }
        return testSets;
    }

    private ExecutionConfiguration getExecutionConfigByName(Project project, String exeConfigName) throws RemoteException, ApiException {
        Collection<ExecutionConfiguration> execConfigs = project.getExecutionConfigurations().getItems();
        for (ExecutionConfiguration elem : execConfigs) {
            if (!elem.getName().equals(exeConfigName)) continue;
            return elem;
        }
        return null;
    }

    private Collection<String> getTestCaseNames(ExecutionConfiguration config) throws RemoteException, ApiException {
        HashSet<String> result = new HashSet<String>();
        for (ExecutionConfigurationItem item : config.getItems()) {
            if (item.getTestSet() == null || item.getTestSet().getTestCases() == null || item.getTestSet().getTestCases().getItems() == null) {
                return null;
            }
            for (Scenario testcase : item.getTestSet().getTestCases().getItems()) {
                result.add(testcase.getName());
            }
        }
        return result;
    }
}

