/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.TptLog;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.TptPluginMasterJobExecutor;
import com.piketec.jenkins.plugins.tpt.TptPluginSingleJobExecutor;
import com.piketec.jenkins.plugins.tpt.WorkLoad;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TptPlugin
extends Builder {
    private transient String exe;
    private String exePaths;
    private final String arguments;
    private boolean isTptMaster;
    private String slaveJob;
    private String slaveJobCount;
    private String slaveJobTries;
    private String tptBindingName;
    private String tptPort;
    private String tptStartUpWaitTime;
    private Boolean enableJunit;
    private String jUnitreport;
    private TptLog.LogLevel jUnitLogLevel;
    private final ArrayList<JenkinsConfiguration> executionConfiguration;
    private transient TptLogger logger;

    @DataBoundConstructor
    public TptPlugin(String exe, String exePaths, String arguments, boolean isTptMaster, String slaveJob, String slaveJobCount, String slaveJobTries, String tptBindingName, String tptPort, ArrayList<JenkinsConfiguration> executionConfiguration, String tptStartUpWaitTime, Boolean enableJunit, String jUnitreport, TptLog.LogLevel jUnitLogLevel) {
        this.exePaths = exe;
        if (exePaths != null) {
            this.exePaths = exePaths;
        }
        this.arguments = arguments;
        this.isTptMaster = isTptMaster;
        this.slaveJob = slaveJob;
        this.slaveJobCount = slaveJobCount;
        this.slaveJobTries = slaveJobTries;
        this.tptBindingName = tptBindingName;
        this.tptPort = tptPort;
        this.tptStartUpWaitTime = tptStartUpWaitTime;
        this.executionConfiguration = new ArrayList();
        if (executionConfiguration != null) {
            this.executionConfiguration.addAll(executionConfiguration);
        }
        this.jUnitreport = jUnitreport;
        this.jUnitLogLevel = jUnitLogLevel;
        this.enableJunit = enableJunit;
    }

    protected Object readResolve() {
        if (this.tptBindingName == null) {
            this.tptBindingName = DescriptorImpl.getDefaultTptBindingName();
        }
        if (this.tptPort == null || this.tptPort.trim().isEmpty()) {
            this.tptPort = DescriptorImpl.getDefaultTptPort();
        }
        if (this.exe != null) {
            this.exePaths = this.exe;
        }
        if (this.slaveJobCount == null) {
            this.slaveJobCount = "0";
        }
        if (this.slaveJobTries == null) {
            this.slaveJobTries = "1";
        }
        if (this.enableJunit == null) {
            this.enableJunit = Boolean.TRUE;
        }
        return this;
    }

    public String getExePaths() {
        return this.exePaths;
    }

    public boolean getIsTptMaster() {
        return this.isTptMaster;
    }

    public boolean isIsTptMaster() {
        return this.isTptMaster;
    }

    public String getSlaveJob() {
        return this.slaveJob;
    }

    public String getSlaveJobCount() {
        return this.slaveJobCount;
    }

    public String getSlaveJobTries() {
        return this.slaveJobTries;
    }

    public String getTptBindingName() {
        return this.tptBindingName;
    }

    public String getTptPort() {
        return this.tptPort;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getTptStartUpWaitTime() {
        return this.tptStartUpWaitTime;
    }

    public List<JenkinsConfiguration> getExecutionConfiguration() {
        return Collections.unmodifiableList(this.executionConfiguration);
    }

    public boolean isEnableJunit() {
        return Boolean.TRUE.equals(this.enableJunit);
    }

    public String getJUnitreport() {
        return this.jUnitreport;
    }

    public TptLog.LogLevel getJUnitLogLevel() {
        return this.jUnitLogLevel;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars environment;
        this.logger = new TptLogger(listener.getLogger());
        try {
            environment = build.getEnvironment(launcher.getListener());
        }
        catch (IOException e) {
            environment = new EnvVars();
            this.logger.error(e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            this.logger.error(e.getLocalizedMessage());
            return false;
        }
        ArrayList<JenkinsConfiguration> normalizedConfigs = new ArrayList<JenkinsConfiguration>();
        for (JenkinsConfiguration ec : this.executionConfiguration) {
            normalizedConfigs.add(ec.replaceAndNormalize(environment));
        }
        if (this.isTptMaster) {
            return this.performAsMaster(build, launcher, listener, environment, normalizedConfigs);
        }
        return this.performWithoutSlaves(build, launcher, listener, environment, normalizedConfigs);
    }

    public boolean performWithoutSlaves(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, EnvVars environment, ArrayList<JenkinsConfiguration> normalizedConfigs) {
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedStringExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launcher.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        String expandedArguments = environment.expand(this.arguments);
        String jUnitXmlPath = environment.expand(this.jUnitreport);
        TptPluginSingleJobExecutor executor = new TptPluginSingleJobExecutor(build, launcher, listener, expandedExePaths, expandedArguments, normalizedConfigs, jUnitXmlPath, this.jUnitLogLevel, this.enableJunit);
        return executor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAsMaster(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, EnvVars environment, ArrayList<JenkinsConfiguration> normalizedConfigs) {
        long expandedTptStartupWaitTime;
        int expandedTptPort;
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedStringExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launcher.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        String jUnitXmlPath = environment.expand(this.jUnitreport);
        if (this.tptPort != null && !this.tptPort.isEmpty()) {
            try {
                expandedTptPort = Integer.parseInt(environment.expand(this.tptPort));
            }
            catch (NumberFormatException e) {
                this.logger.error("The given port " + environment.expand(this.tptPort) + " is not an integer." + " Using default value.");
                expandedTptPort = 1099;
            }
        } else {
            expandedTptPort = 1099;
        }
        String expandedTptBindingName = this.tptBindingName != null && !this.tptBindingName.isEmpty() ? environment.expand(this.tptBindingName) : DescriptorImpl.getDefaultTptBindingName();
        if (this.tptStartUpWaitTime != null && !this.tptStartUpWaitTime.isEmpty()) {
            try {
                expandedTptStartupWaitTime = Integer.parseInt(environment.expand(this.tptStartUpWaitTime)) * 1000;
            }
            catch (NumberFormatException e) {
                this.logger.error("The given TPT startup waiting time \"" + environment.expand(this.tptStartUpWaitTime) + "\" is not an integer. Using default value.");
                expandedTptStartupWaitTime = 60000L;
            }
        } else {
            expandedTptStartupWaitTime = 60000L;
        }
        int parsedSlaveJobCount = 0;
        if (this.slaveJobCount != null && !this.slaveJobCount.isEmpty()) {
            try {
                parsedSlaveJobCount = Integer.parseInt(environment.expand(this.slaveJobCount));
            }
            catch (NumberFormatException e) {
                this.logger.error("The given number of slave jobs to start \"" + environment.expand(this.slaveJobCount) + "\" is not an integer. Using default value.");
            }
        }
        int parsedSlaveJobTries = 1;
        if (this.slaveJobTries != null && !this.slaveJobTries.isEmpty()) {
            try {
                parsedSlaveJobTries = Integer.parseInt(environment.expand(this.slaveJobTries));
            }
            catch (NumberFormatException e) {
                this.logger.error("The given number of tries to execute a slave jobs \"" + environment.expand(this.slaveJobCount) + "\" is not an integer. Using default value.");
            }
        }
        String expandedSlaveJobName = environment.expand(this.slaveJob);
        TptPluginMasterJobExecutor executor = new TptPluginMasterJobExecutor(build, launcher, listener, expandedExePaths, normalizedConfigs, expandedTptPort, expandedTptBindingName, expandedSlaveJobName, expandedTptStartupWaitTime, parsedSlaveJobCount, parsedSlaveJobTries, jUnitXmlPath, this.jUnitLogLevel, this.enableJunit);
        try {
            boolean bl = executor.execute();
            return bl;
        }
        finally {
            WorkLoad.clean(expandedSlaveJobName, build);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static String getDefaultArguments() {
            return "--run build";
        }

        public static String getDefaultTptBindingName() {
            return "TptApi";
        }

        public static boolean getDefaultIsTptMaster() {
            return false;
        }

        public static String getDefaultTptPort() {
            return Integer.toString(1099);
        }

        public static String getDefaultTptStartUpWaitTime() {
            return Integer.toString(60);
        }

        public static boolean getDefaultEnableJunit() {
            return false;
        }

        public static TptLog.LogLevel getDefaultJUnitLogLevel() {
            return TptLog.LogLevel.INFO;
        }

        public static FormValidation doCheckArguments(@QueryParameter String arguments) {
            FormValidation formValidator = null;
            formValidator = arguments == null || arguments.trim().length() == 0 ? FormValidation.error((String)"At least type \"--run build\".") : FormValidation.ok();
            return formValidator;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute TPT test cases";
        }

        public ListBoxModel doFillJUnitLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            for (TptLog.LogLevel goal : TptLog.LogLevel.values()) {
                items.add(goal.name());
            }
            return items;
        }
    }
}

