/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import java.util.LinkedList;
import java.util.List;

class TptLog {
    private List<LogEntry> logEntries = new LinkedList<LogEntry>();

    TptLog() {
    }

    public void log(LogLevel level, String message) {
        if (level == LogLevel.NONE) {
            return;
        }
        this.logEntries.add(new LogEntry(level, message));
    }

    List<LogEntry> getLog(LogLevel level) {
        LinkedList<LogEntry> result = new LinkedList<LogEntry>();
        if (level == LogLevel.NONE) {
            return result;
        }
        for (LogEntry entry : this.logEntries) {
            if (entry.level.ordinal() > level.ordinal()) continue;
            result.add(entry);
        }
        return result;
    }

    public static class LogEntry {
        final LogLevel level;
        final String message;

        LogEntry(LogLevel level, String message) {
            this.level = level;
            this.message = message;
        }
    }

    static enum LogLevel {
        NONE,
        ERROR,
        WARNING,
        INFO,
        ALL;

    }
}

