/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Testcase;
import hudson.FilePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestcaseSummaryParser
extends DefaultHandler {
    private List<Testcase> testCases = new ArrayList<Testcase>();

    public static List<Testcase> parseXml(FilePath xmlFile) throws IOException, InterruptedException {
        try {
            TestcaseSummaryParser parser = new TestcaseSummaryParser();
            SAXParserFactory.newInstance().newSAXParser().parse(xmlFile.read(), (DefaultHandler)parser);
            return parser.testCases;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("XML parser config error: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("I/O error: " + e.getMessage());
        }
    }

    private TestcaseSummaryParser() {
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("Testcase")) {
            Testcase ti = new Testcase();
            ti.setName(attributes.getValue("Name"));
            try {
                ti.setID(Integer.parseInt(attributes.getValue("Id")));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Could not parse ScenarioId", e);
            }
            ti.setResult("ERROR");
            ti.setExecDate(new Date());
            this.testCases.add(ti);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
    }
}

