/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Testcase;
import com.piketec.jenkins.plugins.tpt.TptLog;
import hudson.FilePath;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestcaseParser
extends DefaultHandler {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy");
    private Testcase ti = null;
    private TptLog.LogLevel type = null;
    private StringBuffer logString = null;

    public static Testcase parseXml(FilePath xmlFile) throws IOException, InterruptedException {
        try {
            TestcaseParser parser = new TestcaseParser();
            SAXParserFactory.newInstance().newSAXParser().parse(xmlFile.read(), (DefaultHandler)parser);
            if (parser.ti == null) {
                throw new IOException("XML file " + xmlFile + " does not contain tag <testcaseinformation>");
            }
            return parser.ti;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("XML parser config error: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("I/O error: " + e.getMessage());
        }
    }

    private TestcaseParser() {
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("TestcaseInformation")) {
            this.ti = new Testcase();
            this.ti.setName(attributes.getValue("ScenarioName"));
            try {
                this.ti.setID(Integer.parseInt(attributes.getValue("ScenarioId")));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Could not parse ScenarioId", e);
            }
            this.ti.setExecDuration(attributes.getValue("ExecutionDuration"));
            this.ti.setResult(attributes.getValue("Result"));
            this.ti.setExecDate(this.parseDate(attributes.getValue("ExecDate")));
        } else if (elementName.equalsIgnoreCase("Log")) {
            this.logString = new StringBuffer();
            String type = attributes.getValue("Type");
            if (type == null) {
                this.type = TptLog.LogLevel.ALL;
            } else if (type.equalsIgnoreCase("info") || type.equalsIgnoreCase("customoutput") || type.equalsIgnoreCase("section")) {
                this.type = TptLog.LogLevel.INFO;
            } else if (type.equalsIgnoreCase("warning")) {
                this.type = TptLog.LogLevel.WARNING;
            } else if (type.equalsIgnoreCase("error")) {
                this.type = TptLog.LogLevel.ERROR;
            } else if (!type.equalsIgnoreCase("invisible")) {
                this.type = TptLog.LogLevel.ALL;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("log")) {
            this.ti.addLogEntry(this.logString.toString(), this.type);
            this.logString = null;
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        if (this.logString != null) {
            this.logString.append(ac, i, j);
        }
    }

    private Date parseDate(String value) throws SAXException {
        if (value != null) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                try {
                    return sdf.parse(value);
                }
                catch (ParseException e) {
                    throw new SAXException("Can't parse date format \"" + value + "\"");
                }
            }
        }
        return null;
    }
}

