/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.TptLogger;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import jenkins.model.ParameterizedJobMixIn;

class RetryableJob {
    private Job slaveJob;
    private int tries;
    private Thread runner;
    private TptLogger logger;
    private InterruptedException interruptedException = null;

    RetryableJob(int tries, TptLogger logger, Job slaveJob) {
        if (tries < 1) {
            tries = 1;
        }
        this.tries = tries;
        this.logger = logger;
        this.slaveJob = slaveJob;
    }

    void perform(final AbstractBuild<?, ?> build, final BuildListener listener) {
        this.runner = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean success = false;
                while (RetryableJob.this.tries > 0 && !success) {
                    ArrayList<Future<Run>> futures = new ArrayList<Future<Run>>();
                    try {
                        EnvVars env = build.getEnvironment((TaskListener)listener);
                        env.overrideAll(build.getBuildVariables());
                        ArrayList<Action> parameterActions = new ArrayList<Action>();
                        ArrayList<StringParameterValue> arrayList = new ArrayList<StringParameterValue>();
                        arrayList.add(new StringParameterValue(String.valueOf(Math.random()), String.valueOf(Math.random())));
                        parameterActions.add((Action)new ParametersAction(arrayList));
                        Future<Run> scheduled = RetryableJob.this.schedule(build, RetryableJob.this.slaveJob, ((ParameterizedJobMixIn.ParameterizedJob)RetryableJob.this.slaveJob).getQuietPeriod(), parameterActions);
                        if (scheduled != null) {
                            futures.add(scheduled);
                        }
                        for (Future future : futures) {
                            Run run = (Run)future.get();
                            Result result = run.getResult();
                            if (result != null) {
                                success = result.isBetterOrEqualTo(Result.UNSTABLE);
                            } else {
                                assert (false) : "Build should not be running since we used future.get()";
                                success = true;
                            }
                            if (!future.isCancelled()) continue;
                            RetryableJob.this.tries = 0;
                        }
                    }
                    catch (InterruptedException e) {
                        RetryableJob.this.interruptedException = e;
                        RetryableJob.this.tries = 0;
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                    catch (IOException e) {
                        RetryableJob.this.logger.error(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        RetryableJob.this.logger.error(e.getMessage());
                    }
                    RetryableJob.this.tries--;
                    if (success || RetryableJob.this.tries <= 0) continue;
                    RetryableJob.this.logger.info("Job execution failed. Scheduling job for retry. It is possible that two test cases have the same name, if so please make the test cases names unique.");
                }
            }
        });
        this.runner.start();
    }

    void join() throws InterruptedException {
        this.runner.join();
        if (this.interruptedException != null) {
            throw this.interruptedException;
        }
    }

    void cancel() {
        this.runner.interrupt();
    }

    protected Future<Run> schedule(@Nonnull AbstractBuild<?, ?> build, final @Nonnull Job project, int quietPeriod, @Nonnull List<Action> list) {
        Cause.UpstreamCause cause = new Cause.UpstreamCause(build);
        ArrayList<Action> queueActions = new ArrayList<Action>(list);
        queueActions.add((Action)new CauseAction((Cause)cause));
        if (project instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn parameterizedJobMixIn = new ParameterizedJobMixIn(){

                protected Job<?, ?> asJob() {
                    return project;
                }
            };
            return parameterizedJobMixIn.scheduleBuild2(quietPeriod, queueActions.toArray(new Action[queueActions.size()]));
        }
        return null;
    }
}

