/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.Testcase;
import com.piketec.jenkins.plugins.tpt.TestcaseParser;
import com.piketec.jenkins.plugins.tpt.TestcaseSummaryParser;
import com.piketec.jenkins.plugins.tpt.TptLog;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.XmlStreamWriter;
import hudson.FilePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public final class Publish {
    public static int publishJUnitResults(JenkinsConfiguration jenkinsConfig, FilePath testDataDir, FilePath jUnitOutputDir, TptLogger logger, TptLog.LogLevel logLevel) throws IOException, InterruptedException {
        try (XmlStreamWriter xmlPub = null;){
            String classname = FilenameUtils.getBaseName((String)jenkinsConfig.getTptFile());
            FilePath jUnitXMLFile = new FilePath(jUnitOutputDir, classname + "." + jenkinsConfig.getConfigurationWithUnderscore() + ".xml");
            xmlPub = new XmlStreamWriter();
            xmlPub.initalize(jUnitXMLFile);
            xmlPub.writeTestsuite(classname);
            List<Testcase> testdata = Publish.getTestcases(testDataDir, logger);
            logger.info("Found " + testdata.size() + " test results.");
            for (Testcase tc : testdata) {
                if (tc.getLogEntries(TptLog.LogLevel.ERROR).isEmpty() && "SUCCESS".equals(tc.getResult())) {
                    xmlPub.writeTestcase(classname, tc.getQualifiedName(), tc.getExecDuration());
                    continue;
                }
                StringBuilder log = new StringBuilder();
                for (TptLog.LogEntry entry : tc.getLogEntries(logLevel)) {
                    if (log.length() > 0) {
                        log.append('\n');
                    }
                    log.append('[').append(entry.level.name()).append("] ").append(entry.message);
                }
                xmlPub.writeTestcaseError(classname, tc.getQualifiedName(), tc.getExecDuration(), log.toString());
            }
            int n = testdata.size();
            return n;
        }
    }

    public static List<Testcase> getTestcases(FilePath testDataDir, TptLogger logger) throws IOException, InterruptedException {
        HashSet<FilePath> files = new HashSet<FilePath>();
        Publish.find(testDataDir, "testcase_information.xml", files);
        List<Testcase> testcases = new ArrayList<Testcase>(files.size());
        if (files.size() == 0) {
            FilePath xmlFile = new FilePath(testDataDir, "test_summary.xml");
            if (!xmlFile.exists()) {
                logger.error("No \"test_summary.xml\" found.");
            }
            testcases = TestcaseSummaryParser.parseXml(xmlFile);
        } else {
            for (FilePath f : files) {
                try {
                    Testcase tc = TestcaseParser.parseXml(f);
                    testcases.add(tc);
                }
                catch (IOException e) {
                    logger.error("File \"" + f + "\": " + e.getMessage() + "\n\r");
                }
            }
        }
        return testcases;
    }

    public static void find(FilePath rootdir, String pattern, Collection<FilePath> files) throws IOException, InterruptedException {
        if (rootdir.isDirectory()) {
            List children = rootdir.list();
            if (children != null) {
                for (FilePath child : children) {
                    Publish.find(child, pattern, files);
                }
            }
        } else if (rootdir.exists() && !rootdir.isDirectory() && rootdir.getName().equalsIgnoreCase(pattern)) {
            files.add(rootdir);
        }
    }
}

