/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.Configuration;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class JenkinsConfiguration
implements Describable<JenkinsConfiguration> {
    private final boolean enableTest;
    private final String testSet;
    private long timeout;
    private final String tptFile;
    private final String configuration;
    private final String testdataDir;
    private final String reportDir;

    @DataBoundConstructor
    public JenkinsConfiguration(String tptFile, String configuration, String testdataDir, String reportDir, boolean enableTest, long timeout, String testSet) {
        this.tptFile = tptFile;
        this.configuration = configuration;
        this.testdataDir = testdataDir;
        this.reportDir = reportDir;
        this.enableTest = enableTest;
        this.timeout = timeout;
        this.testSet = testSet;
    }

    protected Object readResolve() {
        if (this.timeout <= 0L) {
            this.timeout = 6L;
        }
        return this;
    }

    public boolean isEnableTest() {
        return this.enableTest;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getTptFile() {
        return this.tptFile;
    }

    public String getTestSet() {
        return this.testSet;
    }

    public String getConfigurationWithUnderscore() {
        return this.configuration.replace(" ", "_");
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Descriptor<JenkinsConfiguration> getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        Descriptor descriptor = instance.getDescriptor(this.getClass());
        return descriptor;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getTestdataDir() {
        return this.testdataDir;
    }

    public JenkinsConfiguration replaceAndNormalize(EnvVars environment) {
        return new JenkinsConfiguration(Util.replaceMacro((String)this.tptFile, (Map)environment), Util.replaceMacro((String)this.configuration, (Map)environment), Util.replaceMacro((String)this.testdataDir, (Map)environment), Util.replaceMacro((String)this.reportDir, (Map)environment), this.enableTest, this.timeout, Util.replaceMacro((String)this.testSet, (Map)environment));
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JenkinsConfiguration> {
        public static FormValidation doCheckTptFile(@QueryParameter File tptFile) {
            if (tptFile != null && tptFile.getName().trim().length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Set the path of the TPT file.");
        }

        public static FormValidation doCheckConfiguration(@QueryParameter String configuration, @AncestorInPath AbstractProject project) {
            if (configuration == null || configuration.trim().length() == 0) {
                return FormValidation.error((String)"Enter a configuration name.");
            }
            return FormValidation.ok();
        }

        public static boolean getDefaultEnableTest() {
            return true;
        }

        public static long getDefaultTimeout() {
            return 6L;
        }

        public static int getDefaultSlaveJobCount() {
            return 0;
        }

        public static String getDefaultTestSet() {
            return "";
        }

        public String getDisplayName() {
            return "";
        }
    }
}

