/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.Project;
import hudson.model.AbstractBuild;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CleanUpTask {
    private static Map<Object, List<CleanUpTask>> registry = new HashMap<Object, List<CleanUpTask>>();
    private Project prj;

    public CleanUpTask(Project project, AbstractBuild masterId) {
        this.prj = project;
        if (this.prj != null) {
            CleanUpTask.register(this, masterId);
        }
    }

    public boolean clean() {
        try {
            return this.prj.closeProject();
        }
        catch (ApiException e) {
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private static synchronized void register(CleanUpTask task, AbstractBuild masterId) {
        List<CleanUpTask> list = registry.get(masterId);
        if (list == null) {
            list = new ArrayList<CleanUpTask>();
            registry.put(masterId, list);
        }
        list.add(task);
    }

    public static synchronized boolean cleanUp(Object masterId) {
        List<CleanUpTask> tasks = registry.remove(masterId);
        if (tasks == null) {
            return true;
        }
        boolean success = true;
        for (CleanUpTask task : tasks) {
            success &= task.clean();
        }
        return success;
    }
}

