/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.GetHostNameCallable;
import com.piketec.jenkins.plugins.tpt.Publish;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.TptApi;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    public static final String TPT_EXE_VAR = "PIKETEC_TPT_EXE";
    public static final String TPT_FILE_VAR = "PIKETEC_TPT_FILE";
    public static final String TPT_EXECUTION_CONFIG_VAR = "PIKETEC_TPT_EXEC_CFG";
    public static final String TPT_TEST_CASE_NAME_VAR = "PIKETEC_TPT_TEST_CASE";
    public static final String TPT_TEST_DATA_DIR_VAR_NAME = "PIKETEC_TPT_TESTDATA_DIR";
    public static final String TPT_REPORT_DIR_VAR_NAME = "PIKETEC_TPT_REPORT_DIR";
    public static final int DEFAULT_TPT_PORT = 1099;
    public static final String DEFAULT_TPT_BINDING_NAME = "TptApi";
    public static final int DEFAULT_STARTUP_WAIT_TIME = 60;
    private static final SimpleDateFormat DDMMYYHHMMSS = new SimpleDateFormat("dd.MM.yy HH:mm:ss");

    public static String getCurrentDateString() {
        Date date = new Date();
        return Utils.formatDate(DDMMYYHHMMSS, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(DateFormat format, Date date) {
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            return format.format(date);
        }
    }

    public static boolean createParentDir(File directory, FilePath workspace) {
        File parentDir = directory.getParentFile();
        if (parentDir == null) {
            return true;
        }
        try {
            new FilePath(workspace, parentDir.getPath()).mkdirs();
            return new FilePath(workspace, parentDir.getPath()).isDirectory();
        }
        catch (IOException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static File getWorkspaceDir(FilePath workspace, TptLogger logger) {
        File workspaceDir = null;
        if (workspace == null) {
            logger.info("Location of the workspace is unknown.");
        } else {
            try {
                workspaceDir = new File(workspace.toURI());
            }
            catch (IOException ioe) {
                logger.info("Failed to get the workspace directory - reason: " + ioe);
            }
            catch (InterruptedException ie) {
                logger.info("Failed to get the workspace directory - reason: " + ie);
            }
        }
        return workspaceDir;
    }

    private static boolean startTpt(AbstractBuild<?, ?> build, Launcher launcher, TptLogger logger, FilePath[] exePaths, int port, String bindingName, long startupWaitTime) throws InterruptedException {
        FilePath exeFile = null;
        for (FilePath f : exePaths) {
            try {
                if (!f.exists()) continue;
                exeFile = f;
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            if (exeFile == null || !exeFile.exists()) {
                logger.error("TPT exe not found.");
                return false;
            }
        }
        catch (IOException e1) {
            logger.error("Could not dertmine existence of TPT.");
            return false;
        }
        Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher);
        starter.cmds(new String[]{exeFile.getRemote(), "--apiPort", Integer.toString(port), "--apiBindingName", bindingName});
        try {
            starter.start();
        }
        catch (IOException e) {
            logger.error("Could not start TPT.");
            return false;
        }
        logger.info("Waiting " + startupWaitTime / 1000L + "s for TPT to start.");
        Thread.sleep(startupWaitTime);
        return true;
    }

    public static TptApi getTptApi(AbstractBuild<?, ?> build, Launcher launcher, TptLogger logger, FilePath[] exePaths, int tptPort, String tptBindingName, long startupWaitTime) throws InterruptedException {
        String hostName = null;
        try {
            hostName = (String)launcher.getChannel().call((Callable)new GetHostNameCallable());
        }
        catch (IOException e1) {
            logger.error("Could not retrive host name: " + e1.getMessage());
            return null;
        }
        logger.info("Try to connect to " + hostName + ":" + tptPort);
        logger.info("TPT Binding name: " + tptBindingName);
        boolean tptSuccessfullyStarted = false;
        try {
            Registry registry = LocateRegistry.getRegistry(hostName, tptPort);
            TptApi remoteApi = (TptApi)registry.lookup(tptBindingName);
            try {
                logger.info("Connected to TPT \"" + remoteApi.getTptVersion() + "\"");
            }
            catch (ApiException e) {
                logger.error(e.getMessage());
            }
            return remoteApi;
        }
        catch (RemoteException e) {
            tptSuccessfullyStarted = Utils.startTpt(build, launcher, logger, exePaths, tptPort, tptBindingName, startupWaitTime);
        }
        catch (NotBoundException e) {
            tptSuccessfullyStarted = Utils.startTpt(build, launcher, logger, exePaths, tptPort, tptBindingName, startupWaitTime);
        }
        if (!tptSuccessfullyStarted) {
            logger.error("Could not start TPT");
            return null;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(hostName, tptPort);
            TptApi remoteApi = (TptApi)registry.lookup(tptBindingName);
            try {
                logger.info("Connected to TPT \"" + remoteApi.getTptVersion() + "\"");
            }
            catch (ApiException e) {
                logger.error(e.getMessage());
            }
            return remoteApi;
        }
        catch (RemoteException e) {
            logger.error(e.getMessage());
            return null;
        }
        catch (NotBoundException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static int publishResults(FilePath workspace, JenkinsConfiguration ec, String jUnitXml, TptLogger logger) throws IOException {
        FilePath reportPath = jUnitXml == null || jUnitXml.trim().isEmpty() ? workspace : new FilePath(workspace, jUnitXml);
        try {
            if (!reportPath.isDirectory()) {
                reportPath.mkdirs();
                if (!reportPath.isDirectory()) {
                    throw new IOException("Could not create report directory \"" + reportPath + "\"");
                }
            }
        }
        catch (InterruptedException ie) {
            throw new IOException("Failed to get the directory: " + reportPath, ie);
        }
        return Publish.publishJUnitResults(workspace, reportPath, ec, logger);
    }

    public static File getAbsolutePath(File workspaceDir, File path) {
        File absPath = workspaceDir;
        absPath = path == null ? (workspaceDir == null ? new File("") : workspaceDir) : (path.isAbsolute() ? path : (workspaceDir == null ? path : new File(workspaceDir, path.toString())));
        return absPath.isAbsolute() ? absPath : absPath.getAbsoluteFile();
    }
}

