/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToMasterNotifier;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.ExecutionConfiguration;
import com.piketec.tpt.api.ExecutionConfigurationItem;
import com.piketec.tpt.api.ExecutionStatus;
import com.piketec.tpt.api.OpenResult;
import com.piketec.tpt.api.Scenario;
import com.piketec.tpt.api.ScenarioGroup;
import com.piketec.tpt.api.ScenarioOrGroup;
import com.piketec.tpt.api.TestSet;
import com.piketec.tpt.api.TptApi;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class TptPluginSlaveExecutor {
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private int tptPort;
    private String tptBindingName;
    private File tptFile;
    private String execCfg;
    private String testDataDir;
    private String reportDir;
    private String testcaseName;
    private long tptStartupWaitTime;

    public TptPluginSlaveExecutor(Launcher launcher, AbstractBuild<?, ?> build, BuildListener listener, FilePath[] exePaths, int tptPort, String tptBindingName, File tptFile, String execCfg, String testDataDir, String reportDir, String testcaseName, long tptStartupWaitTime) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.tptPort = tptPort;
        this.tptBindingName = tptBindingName;
        this.tptFile = tptFile;
        this.execCfg = execCfg;
        this.testDataDir = testDataDir;
        this.reportDir = reportDir;
        this.testcaseName = testcaseName;
        this.tptStartupWaitTime = tptStartupWaitTime;
    }

    public boolean execute() {
        this.logger = new TptLogger(this.listener.getLogger());
        try {
            TptApi api;
            try {
                api = Utils.getTptApi(this.build, this.launcher, this.logger, this.exePaths, this.tptPort, this.tptBindingName, this.tptStartupWaitTime);
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            if (api == null) {
                return false;
            }
            OpenResult openProject = api.openProject(this.tptFile);
            Collection<ExecutionConfiguration> execConfigs = openProject.getProject().getExecutionConfigurations().getItems();
            ExecutionConfiguration config = null;
            for (ExecutionConfiguration elem : execConfigs) {
                if (!elem.getName().equals(this.execCfg)) continue;
                config = elem;
                break;
            }
            if (config == null) {
                this.logger.error("Could not find config");
                return false;
            }
            File oldReportDir = config.getReportDir();
            File oldTestDataDir = config.getDataDir();
            Scenario foundSceneario = this.find(openProject.getProject().getTopLevelTestlet().getTopLevelScenarioOrGroup().getItems(), this.testcaseName);
            if (foundSceneario == null) {
                this.logger.error("Could not find testcase " + this.testcaseName);
                return false;
            }
            FilePath path = null;
            try {
                path = new FilePath(this.build.getWorkspace(), this.testDataDir).absolutize();
                if (Computer.currentComputer() instanceof SlaveComputer) {
                    this.logger.info("Creating and/or cleaning test data directory");
                    path.mkdirs();
                    path.deleteContents();
                }
            }
            catch (IOException e) {
                this.logger.error("Could not create test data dir");
                return false;
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            this.logger.info("Setting test data directory to " + path.getRemote());
            config.setDataDir(new File(path.getRemote()));
            path = null;
            try {
                path = new FilePath(this.build.getWorkspace(), this.reportDir).absolutize();
                if (Computer.currentComputer() instanceof SlaveComputer) {
                    this.logger.info("Creating and/or cleaning report directory");
                    path.mkdirs();
                    path.deleteContents();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
                config.setDataDir(oldTestDataDir);
                return false;
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                config.setDataDir(oldTestDataDir);
                return false;
            }
            this.logger.info("Setting report directory to " + path.getRemote());
            config.setReportDir(new File(path.getRemote()));
            String tmpTestSezName = "JENKINS Exec";
            this.logger.info("Create test set \"" + tmpTestSezName + "\" for execution of \"" + this.testcaseName + "\"");
            TestSet testSet = openProject.getProject().createTestSet(tmpTestSezName);
            testSet.addTestCase(foundSceneario);
            ArrayList<TestSet> oldTestSets = new ArrayList<TestSet>();
            for (ExecutionConfigurationItem item : config.getItems()) {
                oldTestSets.add(item.getTestSet());
                item.setTestSet(testSet);
            }
            ExecutionStatus execStatus = api.run(config);
            while (execStatus.isRunning() || execStatus.isPending()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    execStatus.cancel();
                    break;
                }
            }
            for (ExecutionConfigurationItem item : config.getItems()) {
                item.setTestSet((TestSet)oldTestSets.remove(0));
            }
            try {
                String includes = !StringUtils.isBlank((String)this.testDataDir) ? this.testDataDir : new File(this.tptFile.getParent(), oldTestDataDir.getPath()).getAbsolutePath();
                includes = includes + "\\**\\*.*";
                if (!StringUtils.isBlank((String)this.reportDir) || StringUtils.isBlank((String)oldReportDir.getPath())) {
                    includes = includes + "," + (!StringUtils.isBlank((String)this.reportDir) ? this.reportDir : new File(this.tptFile.getParent(), oldReportDir.getPath()).getAbsolutePath());
                    includes = includes + "\\**\\*.*";
                }
                CopyToMasterNotifier copyToMaster = new CopyToMasterNotifier(includes, "", false, "", false);
                copyToMaster.perform(this.build, this.launcher, this.listener);
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            catch (IOException e) {
                this.logger.error("could not copy results to master: " + e.getMessage());
            }
            this.logger.info("reset test data and report directory to " + oldTestDataDir.getPath() + " and " + oldReportDir.getPath());
            config.setDataDir(oldTestDataDir);
            config.setReportDir(oldReportDir);
            this.logger.info("delete temporary test set \"" + testSet.getName() + "\"");
            openProject.getProject().getTestSets().delete(testSet);
        }
        catch (RemoteException e) {
            this.logger.error(e.getLocalizedMessage());
            e.printStackTrace(this.logger.getLogger());
            return false;
        }
        catch (ApiException e) {
            this.logger.error(e.getLocalizedMessage());
            e.printStackTrace(this.logger.getLogger());
            return false;
        }
        return true;
    }

    private Scenario find(Collection<ScenarioOrGroup> sogs, String name) throws RemoteException, ApiException {
        for (ScenarioOrGroup sog : sogs) {
            if (sog instanceof Scenario) {
                if (!sog.getName().equals(name)) continue;
                return (Scenario)sog;
            }
            Scenario result = this.find(((ScenarioGroup)sog).getItems(), name);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

