/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.TptPluginSlaveExecutor;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class TptPluginSlave
extends Builder {
    private String exePaths;
    private String tptFile;
    private String tptBindingName;
    private String tptPort;
    private String testDataDir;
    private String reportDir;
    private String tptStartUpWaitTime;

    @DataBoundConstructor
    public TptPluginSlave(String exePaths, String tptBindingName, String tptPort, String tptFile, String testDataDir, String reportDir, String tptStartUpWaitTime) {
        this.exePaths = exePaths;
        this.tptFile = tptFile;
        this.tptBindingName = tptBindingName;
        this.tptPort = tptPort;
        this.testDataDir = testDataDir;
        this.reportDir = reportDir;
        this.tptStartUpWaitTime = tptStartUpWaitTime;
    }

    public String getExePaths() {
        return this.exePaths;
    }

    public String getTptFile() {
        return this.tptFile;
    }

    public String getTptBindingName() {
        return this.tptBindingName;
    }

    public String getTptPort() {
        return this.tptPort;
    }

    public String getTestDataDir() {
        return this.testDataDir;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getTptStartUpWaitTime() {
        return this.tptStartUpWaitTime;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String expandedTptFile;
        long expandedTptStartupWaitTime;
        int expandedTptPort;
        EnvVars environment;
        TptLogger logger = new TptLogger(listener.getLogger());
        try {
            environment = build.getEnvironment(launcher.getListener());
        }
        catch (IOException e) {
            environment = new EnvVars();
            logger.error(e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getLocalizedMessage());
            return false;
        }
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launcher.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        if (this.tptPort != null && !this.tptPort.isEmpty()) {
            try {
                expandedTptPort = Integer.parseInt(environment.expand(this.tptPort));
            }
            catch (NumberFormatException e) {
                logger.error("The given port " + environment.expand(this.tptPort) + " is not an integer." + " Using default value.");
                expandedTptPort = DescriptorImpl.getDefaultTptPort();
            }
        } else {
            expandedTptPort = DescriptorImpl.getDefaultTptPort();
        }
        String expandedTptBindingName = this.tptBindingName != null && !this.tptBindingName.isEmpty() ? environment.expand(this.tptBindingName) : DescriptorImpl.getDefaultTptBindingName();
        if (this.tptStartUpWaitTime != null && !this.tptStartUpWaitTime.isEmpty()) {
            try {
                expandedTptStartupWaitTime = Integer.parseInt(environment.expand(this.tptStartUpWaitTime)) * 1000;
            }
            catch (NumberFormatException e) {
                logger.error("The given TPT startup waiting time " + environment.expand(this.tptStartUpWaitTime) + " is not an integer. Using default value.");
                expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
            }
        } else {
            expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
        }
        if ((expandedTptFile = environment.expand(this.tptFile)) == null) {
            expandedTptFile = "";
        }
        String expandedExecConfig = environment.expand("${PIKETEC_TPT_EXEC_CFG}");
        String expandedTestDataDir = environment.expand(this.testDataDir);
        String expandedReportDir = environment.expand(this.reportDir);
        String expandedTestcaseName = environment.expand("${PIKETEC_TPT_TEST_CASE}");
        TptPluginSlaveExecutor executor = new TptPluginSlaveExecutor(launcher, build, listener, expandedExePaths, expandedTptPort, expandedTptBindingName, new File(expandedTptFile), expandedExecConfig, expandedTestDataDir, expandedReportDir, expandedTestcaseName, expandedTptStartupWaitTime);
        return executor.execute();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute TPT tests slave";
        }

        public static String getDefaultExePaths() {
            return "${PIKETEC_TPT_EXE}";
        }

        public static String getDefaultTptFile() {
            return "${PIKETEC_TPT_FILE}";
        }

        public static String getDefaultTptBindingName() {
            return "TptApi";
        }

        public static int getDefaultTptPort() {
            return 1099;
        }

        public static String getDefaultTestDataDir() {
            return "${PIKETEC_TPT_TESTDATA_DIR}";
        }

        public static String getDefaultReportDir() {
            return "${PIKETEC_TPT_REPORT_DIR}";
        }

        public static int getDefaultTptStartUpWaitTime() {
            return 60;
        }
    }
}

