/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TptPluginSingleJobExecutor {
    private boolean onlyNullExitCode = true;
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private String arguments;
    private String jUnitXmlPath;
    private List<JenkinsConfiguration> executionConfigs;

    public TptPluginSingleJobExecutor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, FilePath[] exePaths, String arguments, String jUnitXmlPath, List<JenkinsConfiguration> executionConfigs) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.arguments = arguments;
        this.jUnitXmlPath = jUnitXmlPath;
        this.executionConfigs = executionConfigs;
    }

    boolean execute() {
        boolean success = true;
        FilePath workspace = this.build.getWorkspace();
        File workspaceDir = Utils.getWorkspaceDir(workspace, this.logger);
        FilePath exeFile = null;
        for (FilePath f : this.exePaths) {
            try {
                if (!f.exists()) continue;
                exeFile = f;
                break;
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupted");
                return false;
            }
        }
        if (exeFile == null) {
            this.logger.error("No TPT installation found");
            return false;
        }
        for (JenkinsConfiguration ec : this.executionConfigs) {
            if (!ec.isEnableTest()) continue;
            File dataDir = Utils.getAbsolutePath(workspaceDir, ec.getTestdataDir());
            File reportDir = Utils.getAbsolutePath(workspaceDir, ec.getReportDir());
            File tptFile = Utils.getAbsolutePath(workspaceDir, ec.getTptFile());
            String configurationName = ec.getConfiguration();
            this.logger.info("*** Running TPT-File \"" + tptFile + "\" with configuration \"" + configurationName + "\" now. ***");
            if (Utils.createParentDir(dataDir, workspace) && Utils.createParentDir(reportDir, workspace)) {
                String cmd = this.buildCommand(exeFile, this.arguments, tptFile, dataDir, reportDir, configurationName);
                try {
                    this.launchTPT(this.launcher, this.listener, cmd, ec.getTimeout());
                    this.logger.info("*** Publishing results now ***");
                    Utils.publishResults(workspace, ec, this.jUnitXmlPath, this.logger);
                    continue;
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                    success = false;
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    return false;
                }
            }
            this.logger.error("Failed to create parent directories for " + dataDir + " and/or " + reportDir);
            success = false;
        }
        return success && this.onlyNullExitCode;
    }

    private String buildCommand(FilePath exeFile, String arguments, File tptFile, File dataDir, File reportDir, String configurationName) {
        StringBuilder cmd = new StringBuilder();
        String exeString = exeFile.getRemote();
        if (!exeString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(exeString);
        if (!exeString.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(' ');
        cmd.append(arguments);
        cmd.append(' ');
        String tptFileString = tptFile.toString();
        if (!tptFileString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(tptFileString);
        if (!tptFileString.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(' ');
        if (!configurationName.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(configurationName);
        if (!configurationName.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(" --dataDir ");
        String dataDirString = dataDir.toString();
        if (!dataDirString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(dataDirString);
        if (!dataDirString.endsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(" --reportDir ");
        String reportDirString = reportDir.toString();
        if (!reportDirString.startsWith("\"")) {
            cmd.append('\"');
        }
        cmd.append(reportDirString);
        if (!reportDirString.endsWith("\"")) {
            cmd.append('\"');
        }
        return cmd.toString();
    }

    private void launchTPT(Launcher launcher, BuildListener listener, String cmd, long timeout) throws InterruptedException, IOException {
        this.logger.info("Launching \"" + cmd + "\"");
        Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher);
        starter.cmdAsSingleString(cmd);
        starter.stdout((OutputStream)this.logger.getLogger());
        starter.stderr((OutputStream)this.logger.getLogger());
        Proc tpt = null;
        try {
            tpt = starter.start();
            if (timeout <= 0L) {
                timeout = JenkinsConfiguration.DescriptorImpl.getDefaultTimeout();
            }
            this.logger.info("Waiting for TPT to complete. Timeout: " + timeout + "h");
            int exitcode = tpt.joinWithTimeout(timeout, TimeUnit.HOURS, (TaskListener)listener);
            if (exitcode != 0) {
                this.logger.error("TPT process stops with exit code " + exitcode);
                this.onlyNullExitCode = false;
            }
        }
        catch (IOException e) {
            throw new IOException("TPT launch error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            try {
                tpt.kill();
            }
            catch (Exception e1) {
                throw new IOException("TPT launch error: Interrupt requested, but cannot kill the TPT process. Please kill it manually.");
            }
            throw e;
        }
    }
}

