/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.google.common.collect.ListMultimap;
import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.Utils;
import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.ExecutionConfiguration;
import com.piketec.tpt.api.ExecutionConfigurationItem;
import com.piketec.tpt.api.ExecutionStatus;
import com.piketec.tpt.api.OpenResult;
import com.piketec.tpt.api.Project;
import com.piketec.tpt.api.Scenario;
import com.piketec.tpt.api.TptApi;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.CurrentBuildParameters;
import hudson.plugins.parameterizedtrigger.PredefinedBuildParameters;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class TptPluginMasterJobExecutor {
    private TptLogger logger;
    private Launcher launcher;
    private AbstractBuild<?, ?> build;
    private BuildListener listener;
    private FilePath[] exePaths;
    private String jUnitXmlPath;
    private List<JenkinsConfiguration> executionConfigs;
    private int tptPort;
    private String tptBindingName;
    private String slaveJobName;
    private String testcaseVarName;
    private String execCfgVarName;
    private String tptFileVarName;
    private String exePathsVarName;
    private String testDataDirVarName;
    private String reportDirVarName;
    private long tptStartupWaitTime;

    public TptPluginMasterJobExecutor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, FilePath[] exePaths, String jUnitXmlPath, List<JenkinsConfiguration> executionConfigs, int tptPort, String tptBindingName, String slaveJobName, String testcaseVarName, String execCfgVarName, String tptFileVarName, String exePathsVarName, String testDataDirVarName, String reportDirVarName, long tptStartupWaitTime) {
        this.logger = new TptLogger(listener.getLogger());
        this.launcher = launcher;
        this.build = build;
        this.listener = listener;
        this.exePaths = exePaths;
        this.jUnitXmlPath = jUnitXmlPath;
        this.executionConfigs = executionConfigs;
        this.tptPort = tptPort;
        this.tptBindingName = tptBindingName;
        this.slaveJobName = slaveJobName;
        this.testcaseVarName = testcaseVarName;
        this.execCfgVarName = execCfgVarName;
        this.tptFileVarName = tptFileVarName;
        this.exePathsVarName = exePathsVarName;
        this.testDataDirVarName = testDataDirVarName;
        this.reportDirVarName = reportDirVarName;
        this.tptStartupWaitTime = tptStartupWaitTime;
    }

    public boolean execute() {
        if (!(Computer.currentComputer() instanceof Jenkins.MasterComputer)) {
            this.logger.error("TPT master has to run on master node");
            return false;
        }
        TptApi api = null;
        try {
            api = Utils.getTptApi(this.build, this.launcher, this.logger, this.exePaths, this.tptPort, this.tptBindingName, this.tptStartupWaitTime);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            return false;
        }
        if (api == null) {
            return false;
        }
        for (JenkinsConfiguration ec : this.executionConfigs) {
            ExecutionConfiguration executionConfig;
            if (!ec.isEnableTest()) continue;
            Collection<String> testCases = null;
            FilePath testDataPath = new FilePath(this.build.getWorkspace(), ec.getTestdataDir().getPath());
            FilePath reportPath = new FilePath(this.build.getWorkspace(), ec.getReportDir().getPath());
            try {
                this.logger.info("Create and/or clear test data directory " + testDataPath.getRemote());
                testDataPath.mkdirs();
                testDataPath.deleteContents();
                this.logger.info("Create and/or clear report directory " + reportPath.getRemote());
                reportPath.mkdirs();
                reportPath.deleteContents();
                if (!StringUtils.isBlank((String)this.jUnitXmlPath)) {
                    FilePath path = new FilePath(this.build.getWorkspace(), this.jUnitXmlPath);
                    this.logger.info("Create and/or clear JUnit XML directory " + path.getRemote());
                    path.mkdirs();
                    path.deleteContents();
                }
            }
            catch (InterruptedException e) {
                this.logger.interrupt(e.getMessage());
                return false;
            }
            catch (IOException e) {
                this.logger.error("Could not create or clear directories on master: " + e.getMessage());
                return false;
            }
            try {
                OpenResult openProject = api.openProject(ec.getTptFile());
                executionConfig = this.getExecutionConfigByName(openProject.getProject(), ec.getConfiguration());
                if (executionConfig == null) {
                    this.logger.error("Could not find config");
                    return false;
                }
                testCases = this.getTestCaseNames(executionConfig, this.build, ec);
            }
            catch (RemoteException e) {
                this.logger.error(e.getMessage());
                return false;
            }
            catch (ApiException e) {
                this.logger.error(e.getMessage());
                return false;
            }
            CurrentBuildParameters currentBuildParameters = new CurrentBuildParameters();
            ArrayList futures = new ArrayList();
            for (String testCase : testCases) {
                this.logger.info("Create job for \"" + testCase + "\"");
                PredefinedBuildParameters predefinedBuildParameters = new PredefinedBuildParameters(this.testcaseVarName + "=" + testCase + "\n" + this.execCfgVarName + "=" + ec.getConfiguration() + "\n" + this.tptFileVarName + "=" + ec.getTptFile().getPath().replace("\\", "\\\\") + "\n" + this.exePathsVarName + "=" + this.exePathsAsSingleString().replace("\\", "\\\\") + "\n" + this.testDataDirVarName + "=" + ec.getTestdataDir().getPath().replace("\\", "\\\\") + "\n" + this.reportDirVarName + "=" + ec.getReportDir().getPath().replace("\\", "\\\\"));
                ArrayList configs = new ArrayList();
                configs.add(currentBuildParameters);
                configs.add(predefinedBuildParameters);
                BuildTriggerConfig cfg = new BuildTriggerConfig(this.slaveJobName, ResultCondition.ALWAYS, false, null, (List)configs);
                try {
                    ListMultimap perform3 = cfg.perform3(this.build, this.launcher, this.listener);
                    futures.addAll(perform3.values());
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                    return false;
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
            this.logger.info("Waiting for completion of child jobs");
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    this.logger.interrupt(e.getMessage());
                    this.logger.info("Stopping slave jobs.");
                    for (Future future2 : futures) {
                        future2.cancel(true);
                    }
                    return false;
                }
                catch (ExecutionException e) {
                }
            }
            try {
                File oldTestDataFile = executionConfig.getDataDir();
                File oldReportDir = executionConfig.getReportDir();
                if (ec.getTestdataDir() != null && !ec.getTestdataDir().getPath().isEmpty()) {
                    executionConfig.setDataDir(new File(testDataPath.getRemote()));
                }
                if (ec.getReportDir() != null && !ec.getReportDir().getPath().isEmpty()) {
                    executionConfig.setReportDir(new File(reportPath.getRemote()));
                }
                ExecutionStatus execStatus = api.reGenerateOverviewReport(executionConfig);
                while (execStatus.isRunning() || execStatus.isPending()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        execStatus.cancel();
                        return false;
                    }
                }
                executionConfig.setDataDir(oldTestDataFile);
                executionConfig.setReportDir(oldReportDir);
                int foundTestData = Utils.publishResults(this.build.getWorkspace(), ec, this.jUnitXmlPath, this.logger);
                if (foundTestData == testCases.size()) continue;
                this.logger.error("Found only " + foundTestData + " of " + testCases.size() + " test results.");
                return false;
            }
            catch (RemoteException e) {
                this.logger.error(e.getMessage());
                return false;
            }
            catch (ApiException e) {
                this.logger.error(e.getMessage());
                return false;
            }
            catch (IOException e) {
                this.logger.error("Could not publish result: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private ExecutionConfiguration getExecutionConfigByName(Project project, String name) throws RemoteException, ApiException {
        Collection<ExecutionConfiguration> execConfigs = project.getExecutionConfigurations().getItems();
        for (ExecutionConfiguration elem : execConfigs) {
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        return null;
    }

    private Collection<String> getTestCaseNames(ExecutionConfiguration config, AbstractBuild<?, ?> build, JenkinsConfiguration ec) throws RemoteException, ApiException {
        HashSet<String> result = new HashSet<String>();
        for (ExecutionConfigurationItem item : config.getItems()) {
            for (Scenario testcase : item.getTestSet().getTestCases().getItems()) {
                result.add(testcase.getName());
            }
        }
        return result;
    }

    private String exePathsAsSingleString() {
        StringBuilder sb = new StringBuilder();
        for (FilePath path : this.exePaths) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(path.getRemote());
        }
        return sb.toString();
    }
}

