/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.TptPluginMasterJobExecutor;
import com.piketec.jenkins.plugins.tpt.TptPluginSingleJobExecutor;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TptPlugin
extends Builder {
    private transient String exe;
    private String exePaths;
    private final String arguments;
    private boolean isTptMaster;
    private String slaveJob;
    private String tptBindingName;
    private String tptPort;
    private String report;
    private String tptStartUpWaitTime;
    private final ArrayList<JenkinsConfiguration> executionConfiguration;
    private transient TptLogger logger;

    @DataBoundConstructor
    public TptPlugin(String exe, String exePaths, String arguments, boolean isTptMaster, String slaveJob, String tptBindingName, String tptPort, ArrayList<JenkinsConfiguration> executionConfiguration, String report, String tptStartUpWaitTime) {
        this.exePaths = exe;
        this.exePaths = exePaths;
        this.arguments = arguments;
        this.report = report;
        this.isTptMaster = isTptMaster;
        this.slaveJob = slaveJob;
        this.tptBindingName = tptBindingName;
        this.tptPort = tptPort;
        this.tptStartUpWaitTime = tptStartUpWaitTime;
        this.executionConfiguration = new ArrayList();
        if (executionConfiguration != null) {
            this.executionConfiguration.addAll(executionConfiguration);
        }
    }

    protected Object readResolve() {
        if (this.tptBindingName == null) {
            this.tptBindingName = DescriptorImpl.getDefaultTptBindingName();
        }
        if (this.tptPort == null || this.tptPort.trim().isEmpty()) {
            this.tptPort = Integer.toString(DescriptorImpl.getDefaultTptPort());
        }
        return this;
    }

    public String getExePaths() {
        return this.exePaths;
    }

    public boolean getIsTptMaster() {
        return this.isTptMaster;
    }

    public boolean isIsTptMaster() {
        return this.isTptMaster;
    }

    public String getSlaveJob() {
        return this.slaveJob;
    }

    public String getTptBindingName() {
        return this.tptBindingName;
    }

    public String getTptPort() {
        return this.tptPort;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getReport() {
        return this.report;
    }

    public String getTptStartUpWaitTime() {
        return this.tptStartUpWaitTime;
    }

    public List<JenkinsConfiguration> getExecutionConfiguration() {
        return Collections.unmodifiableList(this.executionConfiguration);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars environment;
        this.logger = new TptLogger(listener.getLogger());
        try {
            environment = build.getEnvironment(launcher.getListener());
        }
        catch (IOException e) {
            environment = new EnvVars();
            this.logger.error(e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            this.logger.error(e.getLocalizedMessage());
            return false;
        }
        ArrayList<JenkinsConfiguration> normalizedConfigs = new ArrayList<JenkinsConfiguration>();
        for (JenkinsConfiguration ec : this.executionConfiguration) {
            normalizedConfigs.add(ec.replaceAndNormalize(environment));
        }
        if (this.isTptMaster) {
            return this.performAsMaster(build, launcher, listener, environment, normalizedConfigs);
        }
        return this.performWithoutSlaves(build, launcher, listener, environment, normalizedConfigs);
    }

    public boolean performWithoutSlaves(AbstractBuild<?, ?> build, Launcher launch, BuildListener listener, EnvVars environment, ArrayList<JenkinsConfiguration> normalizedConfigs) {
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedStringExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launch.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        String expandedArguments = environment.expand(this.arguments);
        String jUnitXmlPath = environment.expand(this.report);
        TptPluginSingleJobExecutor executor = new TptPluginSingleJobExecutor(build, launch, listener, expandedExePaths, expandedArguments, jUnitXmlPath, normalizedConfigs);
        return executor.execute();
    }

    public boolean performAsMaster(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, EnvVars environment, ArrayList<JenkinsConfiguration> normalizedConfigs) {
        long expandedTptStartupWaitTime;
        int expandedTptPort;
        String[] expandedStringExePaths = environment.expand(this.exePaths).split("[,;]");
        FilePath[] expandedExePaths = new FilePath[expandedStringExePaths.length];
        for (int i = 0; i < expandedStringExePaths.length; ++i) {
            expandedExePaths[i] = new FilePath(launcher.getChannel(), environment.expand(expandedStringExePaths[i].trim()));
        }
        String jUnitXmlPath = environment.expand(this.report);
        if (this.tptPort != null && !this.tptPort.isEmpty()) {
            try {
                expandedTptPort = Integer.parseInt(environment.expand(this.tptPort));
            }
            catch (NumberFormatException e) {
                this.logger.error("The given port " + environment.expand(this.tptPort) + " is not an integer." + " Using default value.");
                expandedTptPort = DescriptorImpl.getDefaultTptPort();
            }
        } else {
            expandedTptPort = DescriptorImpl.getDefaultTptPort();
        }
        String expandedTptBindingName = this.tptBindingName != null && !this.tptBindingName.isEmpty() ? environment.expand(this.tptBindingName) : DescriptorImpl.getDefaultTptBindingName();
        if (this.tptStartUpWaitTime != null && !this.tptStartUpWaitTime.isEmpty()) {
            try {
                expandedTptStartupWaitTime = Integer.parseInt(environment.expand(this.tptStartUpWaitTime)) * 1000;
            }
            catch (NumberFormatException e) {
                this.logger.error("The given TPT startup waiting time " + environment.expand(this.tptStartUpWaitTime) + " is not an integer. Using default value.");
                expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
            }
        } else {
            expandedTptStartupWaitTime = DescriptorImpl.getDefaultTptStartUpWaitTime() * 1000;
        }
        String expandedSlaveJobName = environment.expand(this.slaveJob);
        TptPluginMasterJobExecutor executor = new TptPluginMasterJobExecutor(build, launcher, listener, expandedExePaths, jUnitXmlPath, normalizedConfigs, expandedTptPort, expandedTptBindingName, expandedSlaveJobName, "PIKETEC_TPT_TEST_CASE", "PIKETEC_TPT_EXEC_CFG", "PIKETEC_TPT_FILE", "PIKETEC_TPT_EXE", "PIKETEC_TPT_TESTDATA_DIR", "PIKETEC_TPT_REPORT_DIR", expandedTptStartupWaitTime);
        return executor.execute();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static String getDefaultArguments() {
            return "--run build";
        }

        public static String getDefaultTptBindingName() {
            return "TptApi";
        }

        public static boolean getDefaultIsTptMaster() {
            return false;
        }

        public static int getDefaultTptPort() {
            return 1099;
        }

        public static String getDefaultReport() {
            return "";
        }

        public static int getDefaultTptStartUpWaitTime() {
            return 60;
        }

        public static FormValidation doCheckArguments(@QueryParameter String arguments) {
            FormValidation formValidator = null;
            formValidator = arguments == null || arguments.trim().length() == 0 ? FormValidation.error((String)"At least type \"--run build\".") : FormValidation.ok();
            return formValidator;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute TPT test cases";
        }
    }
}

