/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.AssessmentVariable;
import com.piketec.jenkins.plugins.tpt.Testcase;
import hudson.FilePath;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestcaseParser
extends DefaultHandler {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy");
    private Testcase ti = null;
    private StringBuffer errorString = null;
    private StringBuffer logString = null;
    private AssessmentVariable assessmentVariable = null;

    public static Testcase parseXml(FilePath xmlFile) throws IOException {
        try {
            TestcaseParser parser = new TestcaseParser();
            SAXParserFactory.newInstance().newSAXParser().parse(xmlFile.read(), (DefaultHandler)parser);
            if (parser.ti == null) {
                throw new IOException("XML file " + xmlFile + " does not contain tag <testcaseinformation>");
            }
            return parser.ti;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("XML parser config error:" + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("SAX error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("I/O error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted reading XML File: " + e.getMessage(), e);
        }
    }

    private TestcaseParser() {
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("TestcaseInformation")) {
            this.ti = new Testcase();
            this.ti.setName(attributes.getValue("ScenarioName"));
            this.ti.setID(Integer.parseInt(attributes.getValue("ScenarioId")));
            this.ti.setConfiguration(attributes.getValue("PlatformName"));
            this.ti.setExecDuration(attributes.getValue("ExecutionDuration"));
            this.ti.setResult(attributes.getValue("Result"));
            this.ti.setExecDate(this.parseDate(attributes.getValue("ExecDate")));
        } else if (elementName.equalsIgnoreCase("Log")) {
            this.logString = new StringBuffer();
            String type = attributes.getValue("Type");
            if (type.equalsIgnoreCase("error")) {
                this.errorString = new StringBuffer();
            }
        } else if (elementName.equalsIgnoreCase("AssessmentVariable")) {
            String name = attributes.getValue("Name");
            String result = attributes.getValue("Result");
            String type = attributes.getValue("Type");
            String value = attributes.getValue("Value");
            this.assessmentVariable = new AssessmentVariable(name, result, type, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("log")) {
            this.ti.addLogEntry(this.logString.toString());
            if (this.errorString != null) {
                this.ti.addErrors(this.errorString.toString());
            }
            this.logString = null;
            this.errorString = null;
        } else if (qName.equalsIgnoreCase("AssessmentVariable")) {
            this.ti.addAssessmentVariable(this.assessmentVariable);
            this.assessmentVariable = null;
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        if (this.logString != null) {
            this.logString.append(ac, i, j);
        }
        if (this.errorString != null) {
            this.errorString.append(ac, i, j);
        }
        if (this.assessmentVariable != null) {
            this.assessmentVariable.appendMessage(new String(ac, i, j));
        }
    }

    private Date parseDate(String value) throws SAXException {
        if (value != null) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                try {
                    return sdf.parse(value);
                }
                catch (ParseException e) {
                    throw new SAXException("Can't parse date format \"" + value + "\"");
                }
            }
        }
        return null;
    }
}

