/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

import com.piketec.jenkins.plugins.tpt.Configuration.JenkinsConfiguration;
import com.piketec.jenkins.plugins.tpt.Testcase;
import com.piketec.jenkins.plugins.tpt.TestcaseParser;
import com.piketec.jenkins.plugins.tpt.TptLogger;
import com.piketec.jenkins.plugins.tpt.XmlStreamWriter;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

public final class Publish {
    public static int publishJUnitResults(FilePath workspaceDir, FilePath reportFolder, JenkinsConfiguration ex, TptLogger logger) throws IOException {
        XmlStreamWriter xmlPub = null;
        try {
            String classname = ex.getClassname();
            FilePath reportFile = new FilePath(reportFolder, ex.getReportName());
            File testDataText = ex.getTestdataDir();
            FilePath testDataDir = testDataText == null || testDataText.toString().trim().isEmpty() ? workspaceDir : new FilePath(workspaceDir, testDataText.toString());
            xmlPub = new XmlStreamWriter();
            xmlPub.initalize(reportFile);
            xmlPub.writeTestsuite(classname);
            List<Testcase> testdata = Publish.getTestcases(testDataDir, logger);
            logger.info("Found " + testdata.size() + " test results.");
            if (!testdata.isEmpty()) {
                for (Testcase tc : testdata) {
                    if (tc.getErrors().isEmpty() && "SUCCESS".equals(tc.getResult())) {
                        xmlPub.writeTestcase(classname, tc.getQualifiedName(), tc.getExecDuration());
                        continue;
                    }
                    xmlPub.writeTestcaseError(classname, tc.getQualifiedName(), tc.getExecDuration(), tc.getLogEntries().toString());
                }
            }
            int n = testdata.size();
            return n;
        }
        catch (XMLStreamException e) {
            throw new IOException("XML stream error: " + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new IOException("XML configuration error: " + e.getMessage());
        }
        catch (InterruptedException ie) {
            throw new IOException("traverse test data directory failed: " + ie.getMessage());
        }
        finally {
            if (xmlPub != null) {
                xmlPub.close();
            }
        }
    }

    private static List<Testcase> getTestcases(FilePath rootdir, TptLogger logger) throws IOException, InterruptedException {
        HashSet<FilePath> files = new HashSet<FilePath>();
        Publish.find(rootdir, "testcase_information.xml", files);
        ArrayList<Testcase> testcases = new ArrayList<Testcase>(files.size());
        for (FilePath f : files) {
            try {
                Testcase tc = TestcaseParser.parseXml(f);
                testcases.add(tc);
            }
            catch (IOException e) {
                logger.error("File \"" + f + "\": " + e.getMessage() + "\n\r");
            }
        }
        return testcases;
    }

    private static void find(FilePath rootdir, String pattern, Collection<FilePath> files) throws IOException, InterruptedException {
        if (rootdir.isDirectory()) {
            List children = rootdir.list();
            if (children != null) {
                for (FilePath child : children) {
                    Publish.find(child, pattern, files);
                }
            }
        } else if (rootdir.exists() && !rootdir.isDirectory() && rootdir.getName().equalsIgnoreCase(pattern)) {
            files.add(rootdir);
        }
    }
}

