/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt.Configuration;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class JenkinsConfiguration
implements Describable<JenkinsConfiguration> {
    private final boolean enableTest;
    private long timeout;
    private final File tptFile;
    private final String configuration;
    private final File testdataDir;
    private final File reportDir;

    @DataBoundConstructor
    public JenkinsConfiguration(File tptFile, String configuration, File testdataDir, File reportDir, boolean enableTest, long timeout) {
        this.tptFile = tptFile;
        this.configuration = configuration;
        this.testdataDir = testdataDir;
        this.reportDir = reportDir;
        this.enableTest = enableTest;
        this.timeout = timeout;
    }

    protected Object readResolve() {
        if (this.timeout <= 0L) {
            this.timeout = 6L;
        }
        return this;
    }

    public boolean isEnableTest() {
        return this.enableTest;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public File getTptFile() {
        return this.tptFile;
    }

    public String getTptFileName() {
        int end = this.tptFile.getName().lastIndexOf(".");
        return this.tptFile.getName().substring(0, end);
    }

    public String getReportName() {
        return this.getTptFileName() + "." + this.getConfigurationWithUnderscore() + ".xml";
    }

    public String getConfigurationWithUnderscore() {
        return this.configuration.replace(" ", "_");
    }

    public String getClassname() {
        return this.getTptFileName() + "." + this.getConfigurationWithUnderscore();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Descriptor<JenkinsConfiguration> getDescriptor() {
        Descriptor descriptor = Jenkins.getInstance().getDescriptor(this.getClass());
        return descriptor;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public File getTestdataDir() {
        return this.testdataDir;
    }

    public JenkinsConfiguration replaceAndNormalize(EnvVars environment) {
        return new JenkinsConfiguration(this.tptFile, Util.replaceMacro((String)this.configuration, (Map)environment), this.normalizePath(this.testdataDir, environment), this.normalizePath(this.reportDir, environment), this.enableTest, this.timeout);
    }

    private File normalizePath(File f, EnvVars environment) {
        String pathAsString = Util.replaceMacro((String)f.getPath(), (Map)environment);
        if (pathAsString.startsWith("\"")) {
            pathAsString = pathAsString.substring(1);
        }
        if (pathAsString.endsWith("\"")) {
            pathAsString = pathAsString.substring(0, pathAsString.length());
        }
        return new File(pathAsString);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JenkinsConfiguration> {
        public static FormValidation doCheckTptFile(@QueryParameter File tptFile) {
            if (tptFile != null && tptFile.getName().trim().length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Set the path of the TPT file.");
        }

        public static FormValidation doCheckConfiguration(@QueryParameter String configuration) {
            return configuration == null || configuration.trim().length() == 0 ? FormValidation.error((String)"Enter a configuration name.") : FormValidation.ok();
        }

        public static boolean getDefaultEnableTest() {
            return true;
        }

        public static long getDefaultTimeout() {
            return 6L;
        }

        public String getDisplayName() {
            return "";
        }
    }
}

