/*
 * Decompiled with CFR 0.152.
 */
package com.piketec.jenkins.plugins.tpt;

public class AssessmentVariable {
    private final String name;
    private final String result;
    private final String type;
    private final String value;
    private final StringBuilder msg = new StringBuilder();

    public AssessmentVariable(String name, String result, String type, String value) {
        this.name = name;
        this.result = result;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getResult() {
        return this.result;
    }

    public void appendMessage(String n) {
        this.msg.append(n);
    }

    public String getMessage() {
        return this.msg.toString();
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("<AssessmentVariable name=\"" + this.name + "\", result=\"" + this.result + "\"");
        if (this.type != null) {
            b.append(", type=\"" + this.type + "\"");
        }
        if (this.value != null) {
            b.append(", value=\"" + this.value + "\"");
        }
        if (this.msg.length() > 0) {
            b.append(">" + this.msg + "</AssessmentVariable>");
        } else {
            b.append("></AssessmentVariable>");
        }
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int res = 1;
        res = prime * res + (this.msg == null ? 0 : this.msg.toString().hashCode());
        res = prime * res + (this.name == null ? 0 : this.name.hashCode());
        res = prime * res + (this.result == null ? 0 : this.result.hashCode());
        res = prime * res + (this.type == null ? 0 : this.type.hashCode());
        res = prime * res + (this.value == null ? 0 : this.value.hashCode());
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssessmentVariable other = (AssessmentVariable)obj;
        if (this.msg == null ? other.msg != null : !this.msg.toString().equals(other.msg.toString())) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

