/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 PikeTec GmbH
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.piketec.tpt.api.diagram;

import java.rmi.RemoteException;

import com.piketec.tpt.api.ApiException;
import com.piketec.tpt.api.ScenarioOrGroup;
import com.piketec.tpt.api.Testlet;
import com.piketec.tpt.api.steplist.StepListTestlet;

/**
 * Ein Zustand im Diagramm. Der Zustand kann entweder ein {@link StepListTestlet} oder ein
 * {@link DiagramTestlet} enthalten.
 */
public interface State extends DiagramNode, Positioned {

  /**
   * Der Inhalt des Zustands oder NULL wenn der Zustand noch keinen Inhalt hat. Ist entweder ein
   * {@link StepListTestlet} oder ein {@link DiagramTestlet}.
   *
   */
  public Testlet getTestlet() throws ApiException, RemoteException;

  /**
   * Setzt den Typ des enthaltenen Testlet auf {@link StepListTestlet}. Ist der Type bereits vorher
   * StepListTestlet findet keine Aendeurng statt. ACHTUNG Ist der Typ vor der Operation nicht
   * StepListTestlet werden alle existierenden {@link ScenarioOrGroup} geloescht.
   */
  public StepListTestlet makeStepListTestlet() throws ApiException, RemoteException;

  /**
   * Setzt den Typ des enthaltenen Testlet auf {@link DiagramTestlet}. Ist der Type bereits vorher
   * DiagramTestlet findet keine Aendeurng statt. ACHTUNG Ist der Typ vor der Operation nicht
   * DiagramTestlet werden alle existierenden {@link ScenarioOrGroup} geloescht.
   */
  public DiagramTestlet makeDiagramTestlet() throws ApiException, RemoteException;

}
