/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class MablRestApiClientRetryHandler
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryIntervalMillis;

    @Inject
    public MablRestApiClientRetryHandler(@Named(value="com.mabl.http.retryer.max.retries") int maxRetries, @Named(value="com.mabl.http.retryer.retry.interval.milliseconds") long retryIntervalMillis) {
        this.maxRetries = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return this.isRetryStatusCode(response.getStatusLine().getStatusCode()) && executionCount <= this.maxRetries;
    }

    public long getRetryInterval() {
        return this.retryIntervalMillis;
    }

    private boolean isRetryStatusCode(int statusCode) {
        return statusCode == 501 || statusCode == 502;
    }
}

