/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.mabl.integration.jenkins.AbstractWiremockTest;
import com.mabl.integration.jenkins.MablRestApiClientImpl;
import com.mabl.integration.jenkins.MablStepConstants;
import com.mabl.integration.jenkins.MablSystemException;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import com.mabl.integration.jenkins.domain.CreateDeploymentResult;
import com.mabl.integration.jenkins.domain.ExecutionResult;
import com.mabl.integration.jenkins.domain.GetApiKeyResult;
import com.mabl.integration.jenkins.domain.GetApplicationsResult;
import com.mabl.integration.jenkins.domain.GetEnvironmentsResult;
import hudson.util.Secret;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.junit.Assert;
import org.junit.Test;

public class MablRestApiClientTest
extends AbstractWiremockTest {
    private static final String EXPECTED_DEPLOYMENT_EVENT_ID = "d1To4-GYeZ4nl-4Ag1JyQg-v";
    private static final String EXPECTED_ORGANIZATION_ID = "K8NWhtPqOyFnyvJTvCP0uw-w";
    private static final String MABL_APP_BASE_URL = "https://app.mabl.com";
    private static final String fakeProperties = "{\"deployment_origin\":\"" + MablStepConstants.PLUGIN_USER_AGENT + "\"}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createDeploymentAllParametersHappyPathTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String environmentId = "foo-env-e";
        String applicationId = "foo-app-a";
        String labels = "foo-label";
        this.registerPostMapping("/events/deployment", "{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}", "key", "aFakeRestApiKeyId", "{\"environment_id\":\"foo-env-e\",\"application_id\":\"foo-app-a\",\"plan_labels\":[\"foo-label\"],\"properties\":" + fakeProperties + "}");
        this.assertSuccessfulCreateDeploymentRequest("aFakeRestApiKeyId", "foo-env-e", "foo-app-a", "foo-label");
        String eventId1 = "fake-event-id-1";
        String eventId2 = "fake-event-id-2";
        String eventId3 = "fake-event-id-3";
        this.registerGetMappingWithFile(String.format("/execution/result/event/%s", "fake-event-id-1"), WireMock.ok(), "scheduled.json", "key", "aFakeRestApiKeyId");
        this.registerGetMappingWithFile(String.format("/execution/result/event/%s", "fake-event-id-2"), WireMock.ok(), "retrying.json", "key", "aFakeRestApiKeyId");
        this.registerGetMappingWithFile(String.format("/execution/result/event/%s", "fake-event-id-3"), WireMock.ok(), "retry-complete.json", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            ExecutionResult result = client.getExecutionResults("fake-event-id-1");
            Assert.assertEquals((Object)"scheduled", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)0)).status);
            Assert.assertNull((Object)result.eventStatus.getSucceeded());
            Assert.assertNull((Object)result.eventStatus.getSucceededFirstAttempt());
            Assert.assertNull((Object)result.eventStatus.getSucceededWithRetry());
            result = client.getExecutionResults("fake-event-id-2");
            Assert.assertEquals((Object)"failed", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)0)).status);
            Assert.assertEquals((Object)"scheduled", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)1)).status);
            Assert.assertNull((Object)result.eventStatus.getSucceeded());
            Assert.assertNull((Object)result.eventStatus.getSucceededFirstAttempt());
            Assert.assertNull((Object)result.eventStatus.getSucceededWithRetry());
            result = client.getExecutionResults("fake-event-id-3");
            Assert.assertEquals((Object)"failed", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)0)).status);
            Assert.assertEquals((Object)"succeeded", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)1)).status);
            Assert.assertTrue((boolean)result.eventStatus.getSucceeded());
            Assert.assertFalse((boolean)result.eventStatus.getSucceededFirstAttempt());
            Assert.assertTrue((boolean)result.eventStatus.getSucceededWithRetry());
        }
        this.verifyExpectedUrls();
    }

    @Test
    public void createDeploymentOnlyEnvironmentHappyPathTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String environmentId = "foo-env-e";
        String applicationId = null;
        String labels = null;
        this.registerPostMapping("/events/deployment", "{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}", "key", "aFakeRestApiKeyId", "{\"environment_id\":\"foo-env-e\",\"properties\":" + fakeProperties + "}");
        this.assertSuccessfulCreateDeploymentRequest("aFakeRestApiKeyId", "foo-env-e", applicationId, labels);
    }

    @Test
    public void createDeploymentOnlyApplicationHappyPathTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String environmentId = null;
        String applicationId = "foo-app-a";
        String labels = null;
        this.registerPostMapping("/events/deployment", "{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}", "key", "aFakeRestApiKeyId", "{\"application_id\":\"foo-app-a\",\"properties\":" + fakeProperties + "}");
        this.assertSuccessfulCreateDeploymentRequest("aFakeRestApiKeyId", environmentId, "foo-app-a", labels);
    }

    @Test
    public void createDeploymentOnlyLabelsHappyPathTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String environmentId = null;
        String applicationId = null;
        String labels = "foo-label";
        this.registerPostMapping("/events/deployment", "{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}", "key", "aFakeRestApiKeyId", "{\"plan_labels\":[\"foo-label\"],\"properties\":" + fakeProperties + "}");
        this.assertSuccessfulCreateDeploymentRequest("aFakeRestApiKeyId", environmentId, applicationId, "foo-label");
    }

    @Test
    public void createDeploymentRequestWithBranch() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String environmentId = "my-env-e";
        String applicationId = "my-app-a";
        String branch = "my-test-branch";
        this.registerPostMapping("/events/deployment", "{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}", "key", "aFakeRestApiKeyId", String.format("{\"environment_id\":\"%s\",\"application_id\":\"%s\",\"source_control_tag\":\"%s\",\"properties\":%s}", "my-env-e", "my-app-a", "my-test-branch", fakeProperties));
        this.assertSuccessfulCreateDeploymentRequest("aFakeRestApiKeyId", "my-env-e", "my-app-a", null, "my-test-branch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckConnection_Ok() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        this.registerGetMapping("/health/live", new ResponseDefinitionBuilder().withStatus(200), "", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            client.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testCheckConnection_Unauthorized() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        this.registerGetMapping("/health/live", new ResponseDefinitionBuilder().withStatus(401), "", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            client.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testCheckConnection_InvalidKey() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        this.registerGetMapping("/health/live", new ResponseDefinitionBuilder().withStatus(403), "", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            client.checkConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testCheckConnection_ServiceDown() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        this.registerGetMapping("/health/live", new ResponseDefinitionBuilder().withStatus(500), "", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            client.checkConnection();
        }
    }

    private void assertSuccessfulCreateDeploymentRequest(String restApiKey, String environmentId, String applicationId, String labels) throws IOException {
        this.assertSuccessfulCreateDeploymentRequest(restApiKey, environmentId, applicationId, labels, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSuccessfulCreateDeploymentRequest(String restApiKey, String environmentId, String applicationId, String labels, String mablBranch) throws IOException {
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret(restApiKey), MABL_APP_BASE_URL);
            CreateDeploymentProperties properties = new CreateDeploymentProperties();
            properties.setDeploymentOrigin(MablStepConstants.PLUGIN_USER_AGENT);
            CreateDeploymentResult result = client.createDeploymentEvent(environmentId, applicationId, labels, mablBranch, properties);
            Assert.assertEquals((Object)EXPECTED_DEPLOYMENT_EVENT_ID, (Object)result.id);
        }
        this.verifyExpectedUrls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getExecutionResultHappyPathTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String eventId = "fake-event-id";
        this.registerGetMapping(String.format("/execution/result/event/%s", "fake-event-id"), WireMock.ok(), "{  \"plan_execution_metrics\": {    \"total\": 1,    \"passed\": 1,    \"failed\": 0  },  \"journey_execution_metrics\": {    \"total\": 1,    \"passed\": 1,    \"failed\": 0  },  \"executions\": [    {      \"status\": \"succeeded\",      \"success\": true,      \"plan\": {        \"id\": \"xRdJlCbtG5kAbOI9KkwLdA-p\",        \"name\": \"Trigger Happy Plan generated plan\",        \"href\": \"https://api.mabl.com/schedule/runPolicy/xRdJlCbtG5kAbOI9KkwLdA-p\",        \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/test/plans/xRdJlCbtG5kAbOI9KkwLdA-p\"      },      \"plan_execution\": {        \"id\": \"eJ8vgNbPL6RbyZJTIWhQ6Q-pe\",        \"status\": \"succeeded\",        \"href\": \"https://api.mabl.com/execution/runPolicyExecution/xRdJlCbtG5kAbOI9KkwLdA-p\"      },      \"journeys\": [        {          \"id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"name\": \"Trigger Happy Plan\",          \"href\": \"https://api.mabl.com/execution/runPolicyExecution/eJ8vgNbPL6RbyZJTIWhQ6Q-pe/testScriptExecution/RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/test/plan-executions/eJ8vgNbPL6RbyZJTIWhQ6Q-pe/journeys/RhlpLTirVR5QH1nfEm3SfA-j:0\"        }      ],      \"journey_executions\": [        {          \"journey_id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"journey_execution_id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"status\": \"completed\",          \"success\": true,          \"href\": \"https://api.mabl.com/test/journey/RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/train/journeys/RhlpLTirVR5QH1nfEm3SfA-j:0\"        }      ],      \"start_time\": 1523541069783,      \"stop_time\": 1523541117700    }  ]}", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            ExecutionResult result = client.getExecutionResults("fake-event-id");
            Assert.assertEquals((Object)"succeeded", (Object)((ExecutionResult.ExecutionSummary)result.executions.get((int)0)).status);
            Assert.assertTrue((String)"expected success", (boolean)((ExecutionResult.ExecutionSummary)result.executions.get((int)0)).success);
        }
        this.verifyExpectedUrls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getExecutionResultNotFoundTest() throws IOException {
        String fakeRestApiKeyId = "aFakeRestApiKeyId";
        String eventId = "fake-event-id";
        this.registerGetMapping(String.format("/execution/result/event/%s", "fake-event-id"), WireMock.notFound(), "{  \"plan_execution_metrics\": {    \"total\": 1,    \"passed\": 1,    \"failed\": 0  },  \"journey_execution_metrics\": {    \"total\": 1,    \"passed\": 1,    \"failed\": 0  },  \"executions\": [    {      \"status\": \"succeeded\",      \"success\": true,      \"plan\": {        \"id\": \"xRdJlCbtG5kAbOI9KkwLdA-p\",        \"name\": \"Trigger Happy Plan generated plan\",        \"href\": \"https://api.mabl.com/schedule/runPolicy/xRdJlCbtG5kAbOI9KkwLdA-p\",        \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/test/plans/xRdJlCbtG5kAbOI9KkwLdA-p\"      },      \"plan_execution\": {        \"id\": \"eJ8vgNbPL6RbyZJTIWhQ6Q-pe\",        \"status\": \"succeeded\",        \"href\": \"https://api.mabl.com/execution/runPolicyExecution/xRdJlCbtG5kAbOI9KkwLdA-p\"      },      \"journeys\": [        {          \"id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"name\": \"Trigger Happy Plan\",          \"href\": \"https://api.mabl.com/execution/runPolicyExecution/eJ8vgNbPL6RbyZJTIWhQ6Q-pe/testScriptExecution/RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/test/plan-executions/eJ8vgNbPL6RbyZJTIWhQ6Q-pe/journeys/RhlpLTirVR5QH1nfEm3SfA-j:0\"        }      ],      \"journey_executions\": [        {          \"journey_id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"journey_execution_id\": \"RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"status\": \"completed\",          \"success\": true,          \"href\": \"https://api.mabl.com/test/journey/RhlpLTirVR5QH1nfEm3SfA-j:0\",          \"app_href\": \"https://app.mabl.com/workspaces/rFp7Wo2M_L-6hRgqO9H8Gw-w/train/journeys/RhlpLTirVR5QH1nfEm3SfA-j:0\"        }      ],      \"start_time\": 1523541069783,      \"stop_time\": 1523541117700    }  ]}", "key", "aFakeRestApiKeyId");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("aFakeRestApiKeyId"), MABL_APP_BASE_URL);
            ExecutionResult result = client.getExecutionResults("fake-event-id");
            Assert.assertNull((Object)result);
        }
        this.verifyExpectedUrls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getApiKeyObjectFromApiKey() throws IOException {
        String fakeRestApiKeyId = "fakeApiKeyValue";
        this.registerGetMapping(String.format("/apiKeys/self", "fakeApiKeyValue"), WireMock.ok(), "{   \"id\":\"XjO5GsxvWRi_zwbK3-h2PB\",   \"created_time\":1526412082062,   \"created_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",   \"last_updated_time\":1526412082062,   \"last_updated_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",   \"organization_id\":\"K8NWhtPqOyFnyvJTvCP0uw-w\",   \"name\":\"Default API Key\",   \"scopes\":[     {       \"permission\":\"write\",       \"target\":\"events\"     },     {       \"permission\":\"read\",       \"target\":\"execution_results\"     },     {       \"permission\":\"read\",       \"target\":\"api_keys\"     },     {       \"permission\":\"read\",       \"target\":\"environments\"     },     {       \"permission\":\"read\",       \"target\":\"applications\"     }   ],   \"tags\":[     {       \"name\":\"default\"     }   ]}", "key", "fakeApiKeyValue");
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("fakeApiKeyValue"), MABL_APP_BASE_URL);
            GetApiKeyResult result = client.getApiKeyResult();
            Assert.assertEquals((Object)EXPECTED_ORGANIZATION_ID, (Object)result.organization_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getApplicationsReturnsTwoResults() throws IOException {
        String fakeRestApiKeyId = "fakeApiKeyValue";
        String organization_id = "fakeOrganizationId";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/applications")).withQueryParam("organization_id", WireMock.equalTo((String)"fakeOrganizationId")).withBasicAuth("key", "fakeApiKeyValue").withHeader("user-agent", (StringValuePattern)new EqualToPattern(MablStepConstants.PLUGIN_USER_AGENT)).willReturn(WireMock.ok().withHeader("Content-Type", new String[]{"application/json"}).withBody("{   \"applications\":[     {       \"id\":\"zFgoXbl__YHLbezTsBEHig-a\",       \"created_time\":1526412127291,       \"created_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",       \"last_updated_time\":1526412127291,       \"last_updated_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",       \"organization_id\":\"K8NWhtPqOyFnyvJTvCP0uw-w\",       \"name\":\"Wikipedia\"     },     {       \"id\":\"dEfaUiL__HYBeztssIOhNK-a\",       \"created_time\":15264121277623,       \"created_by_id\":\"GuDwew9hMqhjI5xnF8H3A\",       \"last_updated_time\":1426412127761,       \"last_updated_by_id\":\"GuDwew9hMqhjI5xnF8H3A\",       \"organization_id\":\"K8NWhtPqOyFnyvJTvCP0uw-w\",       \"name\":\"Yahoo\"     }   ],   \"cursor\":\"Cj0SN2oKc35tYWJsLWRldnIpCxILQXBwbGljYXRpb24iGHpGZ29YYmxfX1lITGJlelRzQkVIaWctYQwYACAA\"}")));
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("fakeApiKeyValue"), MABL_APP_BASE_URL);
            GetApplicationsResult result = client.getApplicationsResult("fakeOrganizationId");
            Assert.assertEquals((long)2L, (long)result.applications.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getEnvironmentsReturnsOneResult() throws IOException {
        String fakeRestApiKeyId = "fakeApiKeyValue";
        String organization_id = "fakeOrganizationId";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/environments")).withQueryParam("organization_id", WireMock.equalTo((String)"fakeOrganizationId")).withBasicAuth("key", "fakeApiKeyValue").withHeader("user-agent", (StringValuePattern)new EqualToPattern(MablStepConstants.PLUGIN_USER_AGENT)).willReturn(WireMock.ok().withHeader("Content-Type", new String[]{"application/json"}).withBody("{   \"environments\":[     {       \"id\":\"7xNT3ADgflTI2yN9Ihjk_Q-e\",       \"created_time\":1526412127288,       \"created_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",       \"last_updated_time\":1526412127288,       \"last_updated_by_id\":\"FYuRFw9hMzqhjI5xnFYH3A\",       \"organization_id\":\"K8NWhtPqOyFnyvJTvCP0uw-w\",       \"name\":\"Wikipedia\"     }   ],   \"cursor\":\"Cj0SN2oKc35tYWJsLWRldnIpCxILRW52aXJvbm1lbnQiGDd4TlQzQURnZmxUSTJ5TjlJaGprX1EtZQwYACAA\"}")));
        String baseUrl = this.getBaseUrl();
        try (MablRestApiClientImpl client = null;){
            client = new MablRestApiClientImpl(baseUrl, this.mockSecret("fakeApiKeyValue"), MABL_APP_BASE_URL);
            GetEnvironmentsResult result = client.getEnvironmentsResult("fakeOrganizationId");
            Assert.assertEquals((long)1L, (long)result.environments.size());
        }
    }

    @Test(expected=MablSystemException.class)
    public void apiClientDoesntRetryOn503() throws IOException {
        this.registerPostCreateRetryMappings("/events/deployment", "503", 503, 1);
        this.assertSuccessfulCreateDeploymentRequest("pa$$\\/\\/orD", "foo-env-e", "foo-app-a", "foo-label");
    }

    @Test
    public void apiClientRetriesOn501() throws IOException {
        this.registerPostCreateRetryMappings("/events/deployment", "501", 501, 1);
        this.assertSuccessfulCreateDeploymentRequest("pa$$\\/\\/orD", "foo-env-e", "foo-app-a", "foo-label");
    }

    @Test
    public void apiClientRetriesOn501MaxtimesSuccess() throws IOException {
        this.registerPostCreateRetryMappings("/events/deployment", "501", 501, 5);
        this.assertSuccessfulCreateDeploymentRequest("pa$$\\/\\/orD", "foo-env-e", "foo-app-a", "foo-label");
    }

    @Test(expected=MablSystemException.class)
    public void apiClientRetriesOn501OverMaxtimesFailure() throws IOException {
        this.registerPostCreateRetryMappings("/events/deployment", "501", 501, 6);
        this.assertSuccessfulCreateDeploymentRequest("pa$$\\/\\/orD", "foo-env-e", "foo-app-a", "foo-label");
    }

    private void registerPostCreateRetryMappings(String postUrl, String scenario, int status, int numTimes) {
        Object whenState = "Started";
        for (int i = 1; i <= numTimes; ++i) {
            String willState = "Requested " + i + " Times";
            WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)postUrl)).inScenario(scenario).whenScenarioStateIs((String)whenState).willSetStateTo(willState).willReturn(WireMock.aResponse().withStatus(status).withHeader("Content-Type", new String[]{"application/json"}).withBody("" + status)));
            whenState = willState;
        }
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)postUrl)).inScenario(scenario).whenScenarioStateIs((String)whenState).willReturn(WireMock.aResponse().withStatus(201).withHeader("Content-Type", new String[]{"application/json"}).withBody("{  \"id\": \"d1To4-GYeZ4nl-4Ag1JyQg-v\",  \"environment_id\": \"xolMgRp4CwvHQjQUX_MOoA-e\",  \"application_id\": \"smoTxTR8B9oh73qstERNyg-a\",  \"received_time\": 1523541704649}")));
    }

    private Secret mockSecret(String value) {
        try {
            Constructor<?> c = Class.forName("hudson.util.Secret").getDeclaredConstructor(String.class);
            c.setAccessible(true);
            return (Secret)c.newInstance(value);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

