/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.mabl.integration.jenkins.Converter;
import com.mabl.integration.jenkins.MablTestConstants;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import hudson.EnvVars;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;

public class ConverterTest {
    @Test
    public void testJustBuildVars() {
        this.assertSuccessfulConversion(MablTestConstants.JUST_BUILD_PROPS, Converter.convert((EnvVars)new EnvVars().overrideAll(MablTestConstants.BUILD_VARS), (PrintStream)System.out));
    }

    @Test
    public void testGitBuildVars() {
        this.assertSuccessfulConversion(MablTestConstants.GIT_BUILD_PROPS_SSH, Converter.convert((EnvVars)new EnvVars().overrideAll(MablTestConstants.GIT_VARS), (PrintStream)System.out));
    }

    @Test
    public void testGitBuildVarsHttpsUrl() {
        EnvVars envVars = new EnvVars().overrideAll(MablTestConstants.GIT_VARS);
        envVars.override("GIT_URL", "https://github.com/fakeOrg/mabl-integration-plugin.git");
        this.assertSuccessfulConversion(MablTestConstants.GIT_BUILD_PROPS_HTTPS, Converter.convert((EnvVars)envVars, (PrintStream)System.out));
    }

    @Test
    public void testSvnBuildVars() {
        this.assertSuccessfulConversion(MablTestConstants.SVN_BUILD_PROPS, Converter.convert((EnvVars)new EnvVars().overrideAll(MablTestConstants.SVN_VARS), (PrintStream)System.out));
    }

    private void assertSuccessfulConversion(CreateDeploymentProperties expected, CreateDeploymentProperties actual) {
        Assert.assertEquals((Object)expected.getDeploymentOrigin(), (Object)expected.getDeploymentOrigin());
        Assert.assertEquals((Object)expected.getBuildPlanId(), (Object)actual.getBuildPlanId());
        Assert.assertEquals((Object)expected.getBuildPlanName(), (Object)actual.getBuildPlanName());
        Assert.assertEquals((Object)expected.getBuildPlanNumber(), (Object)actual.getBuildPlanNumber());
        Assert.assertEquals((Object)expected.getBuildPlanResultUrl(), (Object)actual.getBuildPlanResultUrl());
        Assert.assertEquals((Object)expected.getRepositoryUrl(), (Object)actual.getRepositoryUrl());
        Assert.assertEquals((Object)expected.getRepositoryName(), (Object)actual.getRepositoryName());
        Assert.assertEquals((Object)expected.getRepositoryBranchName(), (Object)actual.getRepositoryBranchName());
        Assert.assertEquals((Object)expected.getRepositoryRevisionNumber(), (Object)actual.getRepositoryRevisionNumber());
        Assert.assertEquals((Object)expected.getRepositoryCommitUsername(), (Object)expected.getRepositoryCommitUsername());
        Assert.assertEquals((Object)expected.getRepositoryPreviousRevisionNumber(), (Object)expected.getRepositoryPreviousRevisionNumber());
    }
}

