/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.util;

import com.infullmobile.jenkins.plugin.restrictedregister.RestrictedRegistrationPlugin;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.web.util.HtmlUtils;

public final class Utils {
    private static final String[][] STR_SUBSTITUTOR_SPECIAL_CHARACTERS = new String[][]{{"$", "&#36;"}, {"{", "&#123;"}, {"}", "&#125;"}};
    private static final String DESCRIPTOR_NAME_FORMAT = "%s";
    static final Logger LOGGER = Logger.getLogger(RestrictedRegistrationPlugin.class.getSimpleName());
    private static final SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private Utils() {
    }

    public static boolean isAnyStringEmpty(String ... values) {
        for (String entry : values) {
            if (!StringUtils.isEmpty((String)entry)) continue;
            return true;
        }
        return false;
    }

    public static String firstNonEmptyString(String ... values) {
        for (String value : values) {
            if (StringUtils.isEmpty((String)value)) continue;
            return value;
        }
        throw new IllegalArgumentException("Provided 0 arguments or all of them are empty");
    }

    public static void logInfo(String message) {
        LOGGER.log(Level.INFO, message);
    }

    public static void logWarning(String message) {
        LOGGER.log(Level.WARNING, message);
    }

    public static void logError(Throwable t) {
        String ret = t.getMessage() + "\n" + ExceptionUtils.getFullStackTrace((Throwable)t);
        Utils.logError(ret);
    }

    public static void logError(String message) {
        LOGGER.log(Level.SEVERE, message);
    }

    public static String getDescriptorDisplayName(Object object) {
        return String.format(Locale.US, DESCRIPTOR_NAME_FORMAT, object.getClass().getSimpleName());
    }

    public static String fixEmptyString(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return "";
        }
        return input;
    }

    public static String escapeInputString(String value) {
        String ret = HtmlUtils.htmlEscape((String)value);
        for (String[] mapping : STR_SUBSTITUTOR_SPECIAL_CHARACTERS) {
            ret = ret.replace(mapping[0], mapping[1]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getFormattedTimestamp(@Nonnull Date date) {
        SimpleDateFormat simpleDateFormat = FORMAT_TIMESTAMP;
        synchronized (simpleDateFormat) {
            return FORMAT_TIMESTAMP.format(date);
        }
    }
}

