/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.util;

import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class DescribableCollection<T extends Describable<T>, E extends Describable<E>>
implements Describable<E>,
Collection<T> {
    private LinkedList<T> data;

    @DataBoundSetter
    public void setData(LinkedList<T> data) {
        this.clear();
        this.addAll((Collection<? extends T>)data);
    }

    public LinkedList<T> getData() {
        if (this.data == null) {
            this.data = new LinkedList();
        }
        return this.data;
    }

    public T get(Descriptor<T> descriptor) {
        for (Describable item : this) {
            if (!descriptor.isInstance(item)) continue;
            return (T)item;
        }
        try {
            return (T)descriptor.newInstance(null, new JSONObject());
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int size() {
        return this.getData().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getData().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getData().contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getData().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getData().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.getData().toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.getData().add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.getData().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getData().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.getData().addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getData().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getData().retainAll(c);
    }

    @Override
    public void clear() {
        this.getData().clear();
    }
}

