/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.settings;

import com.infullmobile.jenkins.plugin.restrictedregister.ConfigurableDataVerifier;
import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.module.impl.JenkinsDescriptorImpl;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationRuleConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RegistrationRulesSet
extends AbstractDescribableImpl<RegistrationRulesSet> {
    private String ruleName;
    private List<RegistrationRuleConfig> configs;

    @DataBoundConstructor
    public RegistrationRulesSet() {
    }

    public boolean isUserDataValid(JSONObject payload) {
        List<ConfigurableDataVerifier> verifiers = PluginModule.getDefault().getExtensionsProvider().getConfigurableDataVerifiers();
        for (ConfigurableDataVerifier verifier : verifiers) {
            if (this.validateDataWithVerifier(payload, verifier)) continue;
            return false;
        }
        return true;
    }

    public boolean validateDataWithVerifier(JSONObject payload, ConfigurableDataVerifier verifier) {
        RegistrationRuleConfig config = this.getConfigForVerifier(verifier);
        return config == null || verifier.isFormDataValid(payload, config);
    }

    @DataBoundSetter
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    @DataBoundSetter
    public void setConfigs(List<RegistrationRuleConfig> configs) {
        if (this.configs == null) {
            this.configs = new LinkedList<RegistrationRuleConfig>();
        }
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public List<RegistrationRuleConfig> getConfigs() {
        if (this.configs == null) {
            this.configs = new LinkedList<RegistrationRuleConfig>();
        }
        return this.configs;
    }

    @Nullable
    private RegistrationRuleConfig getConfigForVerifier(ConfigurableDataVerifier verifier) {
        for (RegistrationRuleConfig config : this.getConfigs()) {
            if (!verifier.isConfigTypeValid(config)) continue;
            return config;
        }
        return null;
    }

    @Extension
    public static class RegistrationRulesSetDescriptor
    extends Descriptor<RegistrationRulesSet> {
        @Nonnull
        public String getDisplayName() {
            return Utils.getDescriptorDisplayName((Object)this);
        }

        public DescriptorExtensionList<RegistrationRuleConfig, Descriptor<RegistrationRuleConfig>> getConfigDescriptors() {
            return JenkinsDescriptorImpl.getJenkinsInstanceOrDie().getDescriptorList(RegistrationRuleConfig.class);
        }

        public FormValidation doCheckRuleName(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Rule name cannot be empty.");
            }
            return FormValidation.ok();
        }
    }
}

