/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form;

import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.form.IFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.InvalidSecurityRealmException;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.HudsonSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.Messages;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.RRHudsonUserProperty;
import com.infullmobile.jenkins.plugin.restrictedregister.util.Utils;
import hudson.model.User;
import hudson.tasks.Mailer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class ActivationCodeFormValidator
implements IFormValidator<HudsonSecurityRealmRegistration> {
    @Override
    public void verifyFormData(HudsonSecurityRealmRegistration securityRealmRegistration, JSONObject object) throws RegistrationException, InvalidSecurityRealmException {
        String activationCode = (String)BaseFormField.ACTIVATION_CODE.fromJSON(object);
        if (StringUtils.isEmpty((String)activationCode)) {
            throw new RegistrationException(Messages.RRError_Hudson_ActiviationCodeInvalid());
        }
        User user = RRHudsonUserProperty.getUserForActivationCode(activationCode);
        RRHudsonUserProperty hudsonUserProperty = RRHudsonUserProperty.getPropertyForUser(user);
        if (hudsonUserProperty == null) {
            throw new RegistrationException(Messages.RRError_Hudson_ActiviationCodeInvalid());
        }
        if (hudsonUserProperty.getActivated()) {
            throw new RegistrationException(Messages.RRError_Hudson_UserIsActivated());
        }
        Mailer.UserProperty mailerProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        if (mailerProperty == null) {
            throw new RegistrationException(Messages.RRError_Hudson_UserNoEmailAddress());
        }
        String emailAddress = Utils.fixEmptyString(mailerProperty.getAddress());
        if (!EmailValidator.getInstance().isValid(emailAddress)) {
            throw new RegistrationException(Messages.RRError_Hudson_UserInvalidEmail(emailAddress));
        }
    }
}

