/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form;

import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import com.infullmobile.jenkins.plugin.restrictedregister.form.IFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.InvalidSecurityRealmException;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.HudsonSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.HudsonFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form.RequiredFieldsChecker;
import net.sf.json.JSONObject;

public class ActivateFormFieldsValidator
implements IFormValidator<HudsonSecurityRealmRegistration> {
    private static final int MIN_PASSWORD_LENGTH = 8;

    @Override
    public void verifyFormData(HudsonSecurityRealmRegistration securityRealmRegistration, JSONObject object) throws RegistrationException, InvalidSecurityRealmException {
        RequiredFieldsChecker.checkRequiredFields(object, HudsonFormField.PASSWORD, HudsonFormField.PASSWORD_REPEAT);
        String password = (String)HudsonFormField.PASSWORD.fromJSON(object);
        String repeatPassword = (String)HudsonFormField.PASSWORD_REPEAT.fromJSON(object);
        if (!password.equals(repeatPassword)) {
            throw new RegistrationException("Passwords don't match", HudsonFormField.PASSWORD, HudsonFormField.PASSWORD_REPEAT);
        }
        if (password.length() < 8) {
            throw new RegistrationException("Password must be at least 8 characters long", HudsonFormField.PASSWORD);
        }
    }
}

