/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.module.impl;

import com.infullmobile.jenkins.plugin.restrictedregister.PluginModule;
import com.infullmobile.jenkins.plugin.restrictedregister.module.IPluginDescriptor;
import com.infullmobile.jenkins.plugin.restrictedregister.module.impl.JenkinsDescriptorImpl;
import com.infullmobile.jenkins.plugin.restrictedregister.security.SecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.StubSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.ISecurityRealmRegistrationConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.PluginGlobalConfig;
import hudson.security.SecurityRealm;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;

public class PluginDescriptorImpl
implements IPluginDescriptor {
    private static final String ACTION_URL = "restrictedRegister";
    private static final String ACTION_DISPLAY_NAME = "Registration";

    @Override
    public PluginGlobalConfig getGlobalConfig() {
        return (PluginGlobalConfig)GlobalConfiguration.all().get(PluginGlobalConfig.class);
    }

    @Override
    @Nonnull
    public String getRootActionDisplayName() {
        return ACTION_DISPLAY_NAME;
    }

    @Override
    @Nonnull
    public String getRootActionURL() {
        return ACTION_URL;
    }

    @Override
    @Nonnull
    public SecurityRealmRegistration getSecurityRealmRegistration() {
        Jenkins jenkins = JenkinsDescriptorImpl.getJenkinsInstanceOrDie();
        SecurityRealm realm = jenkins.getSecurityRealm();
        List<SecurityRealmRegistration> allRegistrations = PluginModule.getDefault().getExtensionsProvider().getSecurityRealmRegistrations();
        for (SecurityRealmRegistration instance : allRegistrations) {
            if (!instance.isRegistrationForSecurityRealm(realm)) continue;
            return instance;
        }
        return StubSecurityRealmRegistration.INSTANCE;
    }

    @Override
    public <T extends SecurityRealmRegistration> ISecurityRealmRegistrationConfig getConfigForSecurityRealmRegistration(Class<T> type) {
        PluginGlobalConfig pluginConfig = this.getGlobalConfig();
        for (ISecurityRealmRegistrationConfig config : pluginConfig.getRegistrationConfigurations()) {
            if (!config.isConfigForSecurityRealmRegistration(type)) continue;
            return config;
        }
        return null;
    }
}

