/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister;

import com.infullmobile.jenkins.plugin.restrictedregister.form.IFormField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class RegistrationException
extends Exception {
    static final String JSON_KEY_FIELDS = "fields";
    private final Set<IFormField> affectedFields;

    public RegistrationException(String errorMessage) {
        super(errorMessage);
        this.affectedFields = this.createEmptyFieldsSet();
    }

    public RegistrationException(String errorMessage, IFormField ... affectedFields) {
        super(errorMessage);
        this.affectedFields = affectedFields != null && affectedFields.length > 0 ? this.createFieldsSetFrom(affectedFields) : this.createEmptyFieldsSet();
    }

    private Set<IFormField> createEmptyFieldsSet() {
        return new HashSet<IFormField>();
    }

    private Set<IFormField> createFieldsSetFrom(IFormField ... affectedFields) {
        ArrayList fields = new ArrayList(affectedFields.length);
        Collections.addAll(fields, affectedFields);
        return new HashSet<IFormField>(fields);
    }

    @Nonnull
    JSONObject toJson() {
        JSONObject ret = new JSONObject();
        ret.put("message", (Object)this.getLocalizedMessage());
        ret.put(JSON_KEY_FIELDS, (Object)this.getFieldsJsonArray());
        return ret;
    }

    @Nonnull
    private JSONArray getFieldsJsonArray() {
        JSONArray ret = new JSONArray();
        for (IFormField field : this.affectedFields) {
            ret.add((Object)field.getFieldName());
        }
        return ret;
    }
}

