// CHECKSTYLE:OFF

package com.infullmobile.jenkins.plugin.restrictedregister.utils;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Configured Jenkins' root url is invalid
     * 
     */
    public static String RRUrlError_EmptyJenkinsURL() {
        return holder.format("RRUrlError.EmptyJenkinsURL");
    }

    /**
     * Configured Jenkins' root url is invalid
     * 
     */
    public static Localizable _RRUrlError_EmptyJenkinsURL() {
        return new Localizable(holder, "RRUrlError.EmptyJenkinsURL");
    }

    /**
     * Failed to build url, returned value is empty
     * 
     */
    public static String RRUrlError_BuildReturnedNull() {
        return holder.format("RRUrlError.BuildReturnedNull");
    }

    /**
     * Failed to build url, returned value is empty
     * 
     */
    public static Localizable _RRUrlError_BuildReturnedNull() {
        return new Localizable(holder, "RRUrlError.BuildReturnedNull");
    }

}
