// CHECKSTYLE:OFF

package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Invalid entity
     * 
     */
    public static String RRError_Hudson_InvalidEntity() {
        return holder.format("RRError.Hudson.InvalidEntity");
    }

    /**
     * Invalid entity
     * 
     */
    public static Localizable _RRError_Hudson_InvalidEntity() {
        return new Localizable(holder, "RRError.Hudson.InvalidEntity");
    }

    /**
     * Activation code is invalid
     * 
     */
    public static String RRError_Hudson_ActiviationCodeInvalid() {
        return holder.format("RRError.Hudson.ActiviationCodeInvalid");
    }

    /**
     * Activation code is invalid
     * 
     */
    public static Localizable _RRError_Hudson_ActiviationCodeInvalid() {
        return new Localizable(holder, "RRError.Hudson.ActiviationCodeInvalid");
    }

    /**
     * An error occurred when trying to send e-mail to provided address ({0})
     * 
     */
    public static String RRError_Hudson_EmailAfterInitiation(Object arg1) {
        return holder.format("RRError.Hudson.EmailAfterInitiation", arg1);
    }

    /**
     * An error occurred when trying to send e-mail to provided address ({0})
     * 
     */
    public static Localizable _RRError_Hudson_EmailAfterInitiation(Object arg1) {
        return new Localizable(holder, "RRError.Hudson.EmailAfterInitiation", arg1);
    }

    /**
     * An error occurred when attempting saving changes
     * 
     */
    public static String RRError_Hudson_UserIO() {
        return holder.format("RRError.Hudson.UserIO");
    }

    /**
     * An error occurred when attempting saving changes
     * 
     */
    public static Localizable _RRError_Hudson_UserIO() {
        return new Localizable(holder, "RRError.Hudson.UserIO");
    }

    /**
     * Unauthorized, cannot create account with provided user data
     * 
     */
    public static String RRError_NoMatchingRules() {
        return holder.format("RRError.NoMatchingRules");
    }

    /**
     * Unauthorized, cannot create account with provided user data
     * 
     */
    public static Localizable _RRError_NoMatchingRules() {
        return new Localizable(holder, "RRError.NoMatchingRules");
    }

    /**
     * User already exists
     * 
     */
    public static String RRError_Hudson_UserAlreadyExists() {
        return holder.format("RRError.Hudson.UserAlreadyExists");
    }

    /**
     * User already exists
     * 
     */
    public static Localizable _RRError_Hudson_UserAlreadyExists() {
        return new Localizable(holder, "RRError.Hudson.UserAlreadyExists");
    }

    /**
     * Account has invalid-email address assigned ({0})
     * 
     */
    public static String RRError_Hudson_UserInvalidEmail(Object arg1) {
        return holder.format("RRError.Hudson.UserInvalidEmail", arg1);
    }

    /**
     * Account has invalid-email address assigned ({0})
     * 
     */
    public static Localizable _RRError_Hudson_UserInvalidEmail(Object arg1) {
        return new Localizable(holder, "RRError.Hudson.UserInvalidEmail", arg1);
    }

    /**
     * One or more field is empty
     * 
     */
    public static String RRError_EmptyRequiredField() {
        return holder.format("RRError.EmptyRequiredField");
    }

    /**
     * One or more field is empty
     * 
     */
    public static Localizable _RRError_EmptyRequiredField() {
        return new Localizable(holder, "RRError.EmptyRequiredField");
    }

    /**
     * Account is now activated, but confirmation e-mail could not be sent to provided e-mail account ({0})
     * 
     */
    public static String RRError_Hudson_EmailErrorAfterActivation(Object arg1) {
        return holder.format("RRError.Hudson.EmailErrorAfterActivation", arg1);
    }

    /**
     * Account is now activated, but confirmation e-mail could not be sent to provided e-mail account ({0})
     * 
     */
    public static Localizable _RRError_Hudson_EmailErrorAfterActivation(Object arg1) {
        return new Localizable(holder, "RRError.Hudson.EmailErrorAfterActivation", arg1);
    }

    /**
     * Account has no e-mail address assigned
     * 
     */
    public static String RRError_Hudson_UserNoEmailAddress() {
        return holder.format("RRError.Hudson.UserNoEmailAddress");
    }

    /**
     * Account has no e-mail address assigned
     * 
     */
    public static Localizable _RRError_Hudson_UserNoEmailAddress() {
        return new Localizable(holder, "RRError.Hudson.UserNoEmailAddress");
    }

    /**
     * Unauthorized
     * 
     */
    public static String RRError_Hudson_Unauthorized() {
        return holder.format("RRError.Hudson.Unauthorized");
    }

    /**
     * Unauthorized
     * 
     */
    public static Localizable _RRError_Hudson_Unauthorized() {
        return new Localizable(holder, "RRError.Hudson.Unauthorized");
    }

    /**
     * Current Jenkins configuration doesn't allow account creation. Please contact administrator for further assistance.
     * 
     */
    public static String RRError_SecurityRealmNotApplicable() {
        return holder.format("RRError.SecurityRealmNotApplicable");
    }

    /**
     * Current Jenkins configuration doesn't allow account creation. Please contact administrator for further assistance.
     * 
     */
    public static Localizable _RRError_SecurityRealmNotApplicable() {
        return new Localizable(holder, "RRError.SecurityRealmNotApplicable");
    }

    /**
     * Account is already activated
     * 
     */
    public static String RRError_Hudson_UserIsActivated() {
        return holder.format("RRError.Hudson.UserIsActivated");
    }

    /**
     * Account is already activated
     * 
     */
    public static Localizable _RRError_Hudson_UserIsActivated() {
        return new Localizable(holder, "RRError.Hudson.UserIsActivated");
    }

}
