/*
 * Decompiled with CFR 0.152.
 */
package com.etas.jenkins.plugins.CreateTextFile;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import jenkins.security.Roles;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class CreateFileTask
implements Serializable,
Callable<Boolean, IOException> {
    private static final long serialVersionUID = 1L;
    private final String fileContent;
    private final String filePath;
    private final String fileOption;
    private static BuildListener listener;

    public CreateFileTask(String filePath, String fileContent, String fileOption, BuildListener listener) {
        this.filePath = filePath;
        this.fileContent = fileContent;
        this.fileOption = fileOption;
        CreateFileTask.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }

    public Boolean call() throws IOException {
        try {
            FilePath textFile = new FilePath(new File(this.filePath));
            String finalFileContent = "";
            String existingFileContents = "";
            String eol = System.getProperty("line.separator");
            listener.getLogger().println(String.format("Creating/updating file at '%s'", this.filePath));
            if (!textFile.exists()) {
                listener.getLogger().println(String.format("File does not exist at '%s', new file will be created.", this.filePath));
                finalFileContent = this.fileContent;
            } else {
                listener.getLogger().println(String.format("File already exists at '%s', selected write option is '%s'", this.filePath, this.fileOption));
                existingFileContents = textFile.readToString();
                if (this.fileOption.equalsIgnoreCase("overWrite")) {
                    finalFileContent = this.fileContent;
                } else if (this.fileOption.equalsIgnoreCase("appendToEnd")) {
                    finalFileContent = existingFileContents.endsWith(eol) ? existingFileContents.concat(this.fileContent) : existingFileContents.concat(eol + this.fileContent);
                } else if (this.fileOption.equalsIgnoreCase("insertAtStart")) {
                    finalFileContent = existingFileContents.startsWith(eol) ? this.fileContent.concat(existingFileContents) : this.fileContent.concat(eol + existingFileContents);
                }
                textFile.deleteContents();
            }
            finalFileContent = finalFileContent.replaceAll("\n", System.lineSeparator());
            textFile.write(finalFileContent, "UTF-8");
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to create/update file.");
            listener.getLogger().println(e.getMessage());
            return false;
        }
        listener.getLogger().println("File successfully created/updated at " + this.filePath);
        return true;
    }
}

