/*
 * Decompiled with CFR 0.152.
 */
package com.etas.jenkins.plugins.CreateTextFile;

import com.etas.jenkins.plugins.CreateTextFile.CreateFileTask;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CreateFileBuilder
extends Builder {
    private final String textFilePath;
    private final String textFileContent;
    private final String fileOption;
    private final boolean useWorkspace;

    @DataBoundConstructor
    public CreateFileBuilder(String textFilePath, String textFileContent, String fileOption, boolean useWorkspace) {
        this.textFilePath = textFilePath;
        this.textFileContent = textFileContent;
        this.fileOption = fileOption;
        this.useWorkspace = useWorkspace;
    }

    public String getTextFilePath() {
        return this.textFilePath;
    }

    public String getTextFileContent() {
        return this.textFileContent;
    }

    public String getFileOption() {
        return this.fileOption;
    }

    public boolean getUseWorkspace() {
        return this.useWorkspace;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        boolean result = false;
        try {
            String tempFilePath = this.textFilePath;
            if (this.useWorkspace && !this.textFilePath.startsWith("${WORKSPACE}") && !this.textFilePath.startsWith("$WORKSPACE")) {
                tempFilePath = "${WORKSPACE}" + System.getProperty("file.separator", "\\") + this.textFilePath;
            }
            String resolvedFilePath = build.getEnvironment((TaskListener)listener).expand(tempFilePath);
            String resolvedContent = build.getEnvironment((TaskListener)listener).expand(this.textFileContent);
            result = (Boolean)launcher.getChannel().call((Callable)new CreateFileTask(resolvedFilePath, resolvedContent, this.fileOption, listener));
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to create/update file.");
            listener.getLogger().println(e.getMessage());
            return false;
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckTextFilePath(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set file path.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTextFileContent(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the content.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFileOption(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please select one option.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Create/Update Text File";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

