/*
 * Decompiled with CFR 0.152.
 */
package com.datical.integration.jenkins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DaticalDBBuilder
extends Builder {
    private static final Pattern WIN_ENV_VAR_REGEX = Pattern.compile("%([a-zA-Z0-9_]+)%");
    private static final Pattern UNIX_ENV_VAR_REGEX = Pattern.compile("\\$([a-zA-Z0-9_]+)");
    private final String daticalDBProjectDir;
    private final String daticalDBServer;
    private final String daticalDBAction;

    @DataBoundConstructor
    public DaticalDBBuilder(String daticalDBProjectDir, String daticalDBServer, String daticalDBAction) {
        this.daticalDBProjectDir = daticalDBProjectDir;
        this.daticalDBServer = daticalDBServer;
        this.daticalDBAction = daticalDBAction;
    }

    public String getDaticalDBProjectDir() {
        return this.daticalDBProjectDir;
    }

    public String getDaticalDBServer() {
        return this.daticalDBServer;
    }

    public String getDaticalDBAction() {
        return this.daticalDBAction;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        File daticalCmdFile;
        String UNIX_SEP = "/";
        String WINDOWS_SEP = "\\";
        listener.getLogger().println("Datical DB Global Config:");
        listener.getLogger().println("Datical DB Install Dir = " + this.getDescriptor().getDaticalDBInstallDir());
        listener.getLogger().println("Datical DB Drivers Dir = " + this.getDescriptor().getDaticalDBDriversDir());
        listener.getLogger().println("Datical DB Project Config:");
        listener.getLogger().println("Datical DB Project Dir = " + this.daticalDBProjectDir);
        listener.getLogger().println("Datical DB Server = " + this.daticalDBServer);
        listener.getLogger().println("Datical DB Action = " + this.daticalDBAction);
        String daticalCmd = this.getDescriptor().getDaticalDBInstallDir() + "\\repl\\hammer";
        daticalCmd = DaticalDBBuilder.convertSeparator(daticalCmd, launcher.isUnix() ? UNIX_SEP : WINDOWS_SEP);
        if (!launcher.isUnix()) {
            daticalCmd = daticalCmd + ".bat";
        }
        if (!(daticalCmdFile = new File(daticalCmd)).exists()) {
            daticalCmd = this.getDescriptor().getDaticalDBInstallDir() + "\\hammer";
            if (!launcher.isUnix()) {
                daticalCmd = daticalCmd + ".bat";
            }
        }
        String daticalDriversArg = "--drivers=" + this.getDescriptor().getDaticalDBDriversDir();
        String daticalProjectArg = "--project=" + this.daticalDBProjectDir;
        if (this.daticalDBAction.isEmpty()) {
            String errorMessage = "Datical DB Action must be set. Please update the Datical DB build step in the project's configuration.";
            listener.fatalError("Datical DB Action must be set. Please update the Datical DB build step in the project's configuration.");
            return false;
        }
        if ((this.daticalDBAction.equals("forecast") || this.daticalDBAction.equals("snapshot") || this.daticalDBAction.equals("deploy") || this.daticalDBAction.equals("diffChangelog")) && this.daticalDBServer.isEmpty()) {
            String errorMessage = "Datical DB Server must be set if the Datical DB Action is \"" + this.daticalDBAction + "\". Please update Datical DB build step in the project's configuration.";
            listener.fatalError(errorMessage);
            return false;
        }
        if (!launcher.isUnix()) {
            daticalCmd = DaticalDBBuilder.encodeCmdLine(daticalCmd);
        }
        String commandLine = daticalCmd + " " + "\"" + daticalDriversArg + "\"" + " " + "\"" + daticalProjectArg + "\"" + " " + this.getDaticalDBActionForCmd(this.daticalDBAction, this.daticalDBServer);
        String cmdLine = DaticalDBBuilder.convertSeparator(commandLine, launcher.isUnix() ? UNIX_SEP : WINDOWS_SEP);
        listener.getLogger().println("File separators sanitized: " + cmdLine);
        cmdLine = launcher.isUnix() ? DaticalDBBuilder.convertEnvVarsToUnix(cmdLine) : DaticalDBBuilder.convertEnvVarsToWindows(cmdLine);
        listener.getLogger().println("Environment variables sanitized: " + cmdLine);
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (cmdLine != null) {
            args.addTokenized(launcher.isUnix() ? cmdLine : cmdLine);
            listener.getLogger().println("Execute from working directory: " + args.toStringWithQuote());
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
            listener.getLogger().println("Windows command: " + args.toStringWithQuote());
        }
        EnvVars env = null;
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            String errorMessage = "Unable to find environment variables.";
            e.printStackTrace(listener.fatalError("Unable to find environment variables."));
            return false;
        }
        catch (InterruptedException e) {
            String errorMessage = "Unable to find environment variables.";
            e.printStackTrace(listener.fatalError("Unable to find environment variables."));
            return false;
        }
        env.putAll(build.getBuildVariables());
        listener.getLogger().println("Command line: " + args.toStringWithQuote());
        listener.getLogger().println("Working directory: " + build.getWorkspace());
        try {
            int result = launcher.decorateFor(build.getBuiltOn()).launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getWorkspace()).join();
            return result == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = "Command execution failed";
            e.printStackTrace(listener.fatalError("Command execution failed"));
            return false;
        }
        catch (InterruptedException e) {
            String errorMessage = "Command execution failed";
            e.printStackTrace(listener.fatalError("Command execution failed"));
            return false;
        }
    }

    private String getDaticalDBActionForCmd(String daticalDBAction, String daticalDBServer) {
        String daticalDBActionForCmd = null;
        daticalDBActionForCmd = daticalDBAction.equals("checkdrivers") ? daticalDBAction : (daticalDBAction.equals("diffchangelog") ? "diffChangelog " + daticalDBServer : daticalDBAction + " " + "\"" + daticalDBServer + "\"");
        return daticalDBActionForCmd;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static String convertSeparator(String cmdLine, String newSeparator) {
        String match = "[/" + Pattern.quote("\\") + "]";
        String replacement = Matcher.quoteReplacement(newSeparator);
        Pattern words = Pattern.compile("\\S+");
        Pattern urls = Pattern.compile("(https*|ftp|git):");
        StringBuffer sb = new StringBuffer();
        Matcher m = words.matcher(cmdLine);
        while (m.find()) {
            String item = m.group();
            if (urls.matcher(item).find()) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(item.replaceAll(match, replacement)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String encodeCmdLine(String cmdLine) {
        String REGEX = "\\s+";
        Pattern p = Pattern.compile(REGEX);
        String[] s = p.split(cmdLine);
        if (s.length == 1) {
            return cmdLine;
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < s.length; ++x) {
            if (x == 0) {
                sb.append("\"").append(s[x]).append(" ");
                continue;
            }
            if (x == s.length - 1) {
                sb.append(s[x]).append("\"");
                continue;
            }
            sb.append(s[x]).append(" ");
        }
        return sb.toString();
    }

    public static String convertEnvVarsToUnix(String cmdLine) {
        if (cmdLine == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = WIN_ENV_VAR_REGEX.matcher(cmdLine);
        while (m.find()) {
            m.appendReplacement(sb, "\\$$1");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String convertEnvVarsToWindows(String cmdLine) {
        if (cmdLine == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = UNIX_ENV_VAR_REGEX.matcher(cmdLine);
        while (m.find()) {
            m.appendReplacement(sb, "%$1%");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String daticalDBInstallDir;
        private String daticalDBDriversDir;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckDaticalDBInstallDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Datical DB Installation Directory");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDaticalDBDriversDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Datical DB Drivers Directory");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDaticalDBProjectDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the Datical DB Project Directory");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Datical DB";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.daticalDBInstallDir = formData.getString("daticalDBInstallDir");
            this.daticalDBDriversDir = formData.getString("daticalDBDriversDir");
            this.save();
            return super.configure(req, formData);
        }

        public String getDaticalDBInstallDir() {
            return this.daticalDBInstallDir;
        }

        public String getDaticalDBDriversDir() {
            return this.daticalDBDriversDir;
        }
    }
}

