/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service.strategy;

import com.blackduck.integration.IntegrationEscapeUtils;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.detect.exception.DetectJenkinsException;
import com.blackduck.integration.jenkins.detect.service.strategy.DetectExecutionStrategy;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.client.IntHttpClient;
import com.blackduck.integration.rest.credentials.Credentials;
import com.blackduck.integration.rest.credentials.CredentialsBuilder;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.proxy.ProxyInfoBuilder;
import com.blackduck.integration.rest.request.Request;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.OperatingSystemType;
import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.text.StringEscapeUtils;

public class DetectScriptStrategy
extends DetectExecutionStrategy {
    public static final String DETECT_INSTALL_DIRECTORY = "Detect_Installation";
    public static final String SUPPORTED_SHELL_SCRIPT_URL = "https://detect.blackduck.com/detect11.sh";
    public static final String SHELL_SCRIPT_FILENAME = "detect11.sh";
    public static final String SUPPORTED_POWERSHELL_SCRIPT_URL = "https://detect.blackduck.com/detect11.ps1";
    public static final String POWERSHELL_SCRIPT_FILENAME = "detect11.ps1";
    private final JenkinsIntLogger logger;
    private final OperatingSystemType operatingSystemType;
    private final JenkinsProxyHelper jenkinsProxyHelper;
    private final String toolsDirectory;

    public DetectScriptStrategy(JenkinsIntLogger logger, JenkinsProxyHelper jenkinsProxyHelper, OperatingSystemType operatingSystemType, String toolsDirectory) {
        this.logger = logger;
        this.jenkinsProxyHelper = jenkinsProxyHelper;
        this.operatingSystemType = operatingSystemType;
        this.toolsDirectory = toolsDirectory;
    }

    @Override
    public Function<String, String> getArgumentEscaper() {
        if (this.operatingSystemType == OperatingSystemType.WINDOWS) {
            return IntegrationEscapeUtils::escapePowerShell;
        }
        return StringEscapeUtils::escapeXSI;
    }

    @Override
    public MasterToSlaveCallable<ArrayList<String>, IntegrationException> getSetupCallable() throws IntegrationException {
        ProxyInfo proxyInfo;
        String scriptFileName;
        String scriptUrl;
        if (this.operatingSystemType == OperatingSystemType.WINDOWS) {
            scriptUrl = SUPPORTED_POWERSHELL_SCRIPT_URL;
            scriptFileName = POWERSHELL_SCRIPT_FILENAME;
        } else {
            scriptUrl = SUPPORTED_SHELL_SCRIPT_URL;
            scriptFileName = SHELL_SCRIPT_FILENAME;
        }
        try {
            proxyInfo = this.jenkinsProxyHelper.getProxyInfo(scriptUrl);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Black Duck Detect for Jenkins could not resolve proxy info from Jenkins because: " + e.getMessage());
            this.logger.warn("Continuing without proxy...");
            this.logger.trace("Stack trace:", (Throwable)e);
            proxyInfo = ProxyInfo.NO_PROXY_INFO;
        }
        String proxyHost = proxyInfo.getHost().orElse(null);
        int proxyPort = proxyInfo.getPort();
        String proxyUsername = proxyInfo.getUsername().orElse(null);
        String proxyPassword = proxyInfo.getPassword().orElse(null);
        String proxyNtlmDomain = proxyInfo.getNtlmDomain().orElse(null);
        String proxyNtlmWorkstation = proxyInfo.getNtlmWorkstation().orElse(null);
        return new SetupCallableImpl(this.logger, this.toolsDirectory, scriptUrl, scriptFileName, proxyHost, proxyPort, proxyUsername, proxyPassword, proxyNtlmDomain, proxyNtlmWorkstation);
    }

    public static class SetupCallableImpl
    extends MasterToSlaveCallable<ArrayList<String>, IntegrationException> {
        private static final long serialVersionUID = -4954105356640324485L;
        private final JenkinsIntLogger logger;
        private final String toolsDirectory;
        private final String scriptUrl;
        private final String proxyHost;
        private final int proxyPort;
        private final String proxyUsername;
        private final String proxyPassword;
        private final String proxyNtlmDomain;
        private final String proxyNtlmWorkstation;
        private final String scriptFileName;

        public SetupCallableImpl(JenkinsIntLogger logger, String toolsDirectory, String scriptUrl, String scriptFileName, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyNtlmDomain, String proxyNtlmWorkstation) {
            this.logger = logger;
            this.toolsDirectory = toolsDirectory;
            this.scriptUrl = scriptUrl;
            this.scriptFileName = scriptFileName;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
            this.proxyNtlmDomain = proxyNtlmDomain;
            this.proxyNtlmWorkstation = proxyNtlmWorkstation;
        }

        public ArrayList<String> call() throws IntegrationException {
            String scriptRemotePath;
            try {
                Path installationDirectory = Paths.get(this.toolsDirectory, DetectScriptStrategy.DETECT_INSTALL_DIRECTORY);
                Files.createDirectories(installationDirectory, new FileAttribute[0]);
                Path detectScriptPath = installationDirectory.resolve(this.scriptFileName);
                this.logger.info(String.format("Downloading Detect script from %s to %s", this.scriptUrl, detectScriptPath));
                IntHttpClient intHttpClient = new IntHttpClient((IntLogger)this.logger, new Gson(), 120, false, this.rebuildProxyInfo());
                Request request = (Request)new Request.Builder().url(new HttpUrl(this.scriptUrl)).build();
                try (Response response = intHttpClient.execute(request);){
                    response.throwExceptionForError();
                    Files.copy(response.getContent(), detectScriptPath, StandardCopyOption.REPLACE_EXISTING);
                }
                scriptRemotePath = detectScriptPath.toRealPath(new LinkOption[0]).toString();
            }
            catch (Exception e) {
                throw new DetectJenkinsException("[ERROR] The Detect script was not downloaded successfully: " + e.getMessage(), e);
            }
            if (OperatingSystemType.determineFromSystem() == OperatingSystemType.WINDOWS) {
                return new ArrayList<String>(Arrays.asList("powershell", String.format("\"Import-Module '%s'; detect\"", scriptRemotePath)));
            }
            return new ArrayList<String>(Arrays.asList("bash", scriptRemotePath));
        }

        private ProxyInfo rebuildProxyInfo() {
            CredentialsBuilder credentialsBuilder = Credentials.newBuilder();
            credentialsBuilder.setUsernameAndPassword(this.proxyUsername, this.proxyPassword);
            Credentials proxyCredentials = (Credentials)credentialsBuilder.build();
            ProxyInfoBuilder proxyInfoBuilder = ProxyInfo.newBuilder();
            proxyInfoBuilder.setHost(this.proxyHost);
            proxyInfoBuilder.setPort(this.proxyPort);
            proxyInfoBuilder.setCredentials(proxyCredentials);
            proxyInfoBuilder.setNtlmDomain(this.proxyNtlmDomain);
            proxyInfoBuilder.setNtlmWorkstation(this.proxyNtlmWorkstation);
            return (ProxyInfo)proxyInfoBuilder.build();
        }
    }
}

