package com.atlassian.plugin.loaders;

import java.io.File;
import java.util.List;

import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;

/**
 * A PluginLoader which manages plugins specified by a roster file.
 *
 * @see RosterFileScanner
 * @since v3.0.24
 */
public class RosterFilePluginLoader extends ScanningPluginLoader
{
    /**
     * Create a RosterFilePluginLoader which loads a given roster file to locate plugins.
     *
     * @param rosterFile the file to load the plugin roster from, as per {@link RosterFileScanner}.
     * @param pluginFactories the factories used to convert PluginArtifacts to Plugins.
     * @param pluginEventManager the event manager for the plugin system.
     */
    public RosterFilePluginLoader(final File rosterFile,
            final List<PluginFactory> pluginFactories,
            final PluginEventManager pluginEventManager)
    {
        this(rosterFile, pluginFactories, new DefaultPluginArtifactFactory(), pluginEventManager);
    }

    /**
     * Create a RosterFilePluginLoader which loads a given roster file to locate plugins.
     *
     * @param rosterFile the file to load the plugin roster from, as per {@link RosterFileScanner}.
     * @param pluginFactories the factories used to convert PluginArtifacts to Plugins.
     * @param pluginArtifactFactory the factory used to convert URIs to PluginArtifacts.
     * @param pluginEventManager the event manager for the plugin system.
     */
    public RosterFilePluginLoader(final File rosterFile,
            final List<PluginFactory> pluginFactories,
            final PluginArtifactFactory pluginArtifactFactory,
            final PluginEventManager pluginEventManager)
    {
        super(new RosterFileScanner(rosterFile), pluginFactories, pluginArtifactFactory, pluginEventManager);
    }
}
